/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecurityPermission;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.commons.codec.binary.Base64;

public final class SystemCredentials
extends Credentials {
    private static final SecurityPermission SYSTEM_CREDENTIALS_PERMISSION = new SecurityPermission("systemCredentialsPermission");
    private static SystemCredentials SYSTEM_CREDS = null;
    private static final String SYSTEM_PRINCIPAL = "!SYSTEM";
    private final TCredentials AS_THRIFT;

    SystemCredentials(Instance instance) {
        super(SYSTEM_PRINCIPAL, (AuthenticationToken)SystemToken.get(instance));
        this.AS_THRIFT = super.toThrift(instance);
    }

    public static SystemCredentials get() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SYSTEM_CREDENTIALS_PERMISSION);
        }
        if (SYSTEM_CREDS == null) {
            SYSTEM_CREDS = new SystemCredentials(HdfsZooInstance.getInstance());
        }
        return SYSTEM_CREDS;
    }

    public TCredentials toThrift(Instance instance) {
        if (!this.AS_THRIFT.getInstanceId().equals(instance.getInstanceID())) {
            throw new IllegalArgumentException("Unexpected instance used for " + SystemCredentials.class.getSimpleName() + ": " + instance.getInstanceID());
        }
        return this.AS_THRIFT;
    }

    public static final class SystemToken
    extends PasswordToken {
        public SystemToken() {
        }

        private SystemToken(byte[] systemPassword) {
            super(systemPassword);
        }

        private static SystemToken get(Instance instance) {
            MessageDigest md;
            byte[] instanceIdBytes = instance.getInstanceID().getBytes(Constants.UTF8);
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to compute configuration checksum", e);
            }
            md.update(ServerConstants.WIRE_VERSION.toString().getBytes(Constants.UTF8));
            md.update(instanceIdBytes);
            for (Map.Entry entry : ServerConfiguration.getSiteConfiguration()) {
                if (!((String)entry.getKey()).startsWith(Property.INSTANCE_PREFIX.toString())) continue;
                md.update(((String)entry.getKey()).getBytes(Constants.UTF8));
                md.update(((String)entry.getValue()).getBytes(Constants.UTF8));
            }
            byte[] confChecksum = md.digest();
            int wireVersion = ServerConstants.WIRE_VERSION;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(12 + instanceIdBytes.length + confChecksum.length);
            DataOutputStream out = new DataOutputStream(bytes);
            try {
                out.write(wireVersion * -1);
                out.write(instanceIdBytes.length);
                out.write(instanceIdBytes);
                out.write(confChecksum.length);
                out.write(confChecksum);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new SystemToken(Base64.encodeBase64((byte[])bytes.toByteArray()));
        }
    }
}

