/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.tabletserver.MemoryManagementActions;
import org.apache.accumulo.server.tabletserver.MemoryManager;
import org.apache.accumulo.server.tabletserver.TabletState;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class LargestFirstMemoryManager
implements MemoryManager {
    private static final Logger log = Logger.getLogger(LargestFirstMemoryManager.class);
    private static final int TSERV_MINC_MAXCONCURRENT_NUMWAITING_MULTIPLIER = 2;
    private long maxMemory = -1L;
    private int maxConcurrentMincs;
    private int numWaitingMultiplier;
    private long prevIngestMemory = 0L;
    private double compactionThreshold = 0.5;
    private long maxObserved = 0L;
    private HashMap<Text, Long> mincIdleThresholds = new HashMap();
    private static final long zerotime = System.currentTimeMillis();
    private ServerConfiguration config = null;

    LargestFirstMemoryManager(long maxMemory, int maxConcurrentMincs, int numWaitingMultiplier) {
        this();
        this.maxMemory = maxMemory;
        this.maxConcurrentMincs = maxConcurrentMincs;
        this.numWaitingMultiplier = numWaitingMultiplier;
    }

    @Override
    public void init(ServerConfiguration conf) {
        this.config = conf;
        this.maxMemory = conf.getConfiguration().getMemoryInBytes(Property.TSERV_MAXMEM);
        this.maxConcurrentMincs = conf.getConfiguration().getCount(Property.TSERV_MINC_MAXCONCURRENT);
        this.numWaitingMultiplier = 2;
    }

    public LargestFirstMemoryManager() {
    }

    @Override
    public MemoryManagementActions getMemoryManagementActions(List<TabletState> tablets) {
        if (this.maxMemory < 0L) {
            throw new IllegalStateException("need to initialize Largst");
        }
        this.mincIdleThresholds.clear();
        long ingestMemory = 0L;
        long compactionMemory = 0L;
        KeyExtent largestMemTablet = null;
        long largestMemTableLoad = 0L;
        KeyExtent largestIdleMemTablet = null;
        long largestIdleMemTableLoad = 0L;
        int numWaitingMincs = 0;
        long ct = System.currentTimeMillis();
        long largestMemTableIdleTime = -1L;
        long largestMemTableSize = -1L;
        long largestIdleMemTableIdleTime = -1L;
        long largestIdleMemTableSize = -1L;
        for (TabletState ts : tablets) {
            long mts = ts.getMemTableSize();
            long mcmts = ts.getMinorCompactingMemTableSize();
            long idleTime = ts.getLastCommitTime() > 0L ? ct - ts.getLastCommitTime() : ct - zerotime;
            ingestMemory += mts;
            long tml = LargestFirstMemoryManager.timeMemoryLoad(mts, idleTime);
            if (mcmts == 0L && mts > 0L) {
                Text tableId;
                if (tml > largestMemTableLoad) {
                    largestMemTableLoad = tml;
                    largestMemTablet = ts.getExtent();
                    largestMemTableSize = mts;
                    largestMemTableIdleTime = idleTime;
                }
                if (!this.mincIdleThresholds.containsKey(tableId = ts.getExtent().getTableId())) {
                    this.mincIdleThresholds.put(tableId, this.config.getTableConfiguration(tableId.toString()).getTimeInMillis(Property.TABLE_MINC_COMPACT_IDLETIME));
                }
                if (idleTime > this.mincIdleThresholds.get(tableId) && tml > largestIdleMemTableLoad) {
                    largestIdleMemTableLoad = tml;
                    largestIdleMemTablet = ts.getExtent();
                    largestIdleMemTableSize = mts;
                    largestIdleMemTableIdleTime = idleTime;
                }
            }
            compactionMemory += mcmts;
            if (mcmts <= 0L) continue;
            ++numWaitingMincs;
        }
        if (ingestMemory + compactionMemory > this.maxObserved) {
            this.maxObserved = ingestMemory + compactionMemory;
        }
        long memoryChange = ingestMemory - this.prevIngestMemory;
        this.prevIngestMemory = ingestMemory;
        MemoryManagementActions mma = new MemoryManagementActions();
        mma.tabletsToMinorCompact = new ArrayList<KeyExtent>();
        boolean startMinC = false;
        if (numWaitingMincs < this.maxConcurrentMincs * this.numWaitingMultiplier) {
            if (memoryChange >= 0L && (double)(ingestMemory + memoryChange) > this.compactionThreshold * (double)this.maxMemory) {
                startMinC = true;
            } else if (largestIdleMemTablet != null) {
                startMinC = true;
                largestMemTablet = largestIdleMemTablet;
                largestMemTableLoad = largestIdleMemTableLoad;
                largestMemTableSize = largestIdleMemTableSize;
                largestMemTableIdleTime = largestIdleMemTableIdleTime;
                log.debug((Object)"IDLE minor compaction chosen");
            }
        }
        if (startMinC && largestMemTablet != null) {
            mma.tabletsToMinorCompact.add(largestMemTablet);
            log.debug((Object)String.format("COMPACTING %s  total = %,d ingestMemory = %,d", largestMemTablet.toString(), ingestMemory + compactionMemory, ingestMemory));
            log.debug((Object)String.format("chosenMem = %,d chosenIT = %.2f load %,d", largestMemTableSize, (double)largestMemTableIdleTime / 1000.0, largestMemTableLoad));
        } else if (memoryChange < 0L) {
            log.debug((Object)String.format("BEFORE compactionThreshold = %.3f maxObserved = %,d", this.compactionThreshold, this.maxObserved));
            if (this.compactionThreshold < 0.82 && (double)this.maxObserved < 0.8 * (double)this.maxMemory) {
                this.compactionThreshold *= 1.1;
            } else if (this.compactionThreshold > 0.056 && (double)this.maxObserved > 0.9 * (double)this.maxMemory) {
                this.compactionThreshold *= 0.9;
            }
            this.maxObserved = 0L;
            log.debug((Object)String.format("AFTER compactionThreshold = %.3f", this.compactionThreshold));
        }
        return mma;
    }

    @Override
    public void tabletClosed(KeyExtent extent) {
    }

    static long timeMemoryLoad(long mem, long time) {
        double minutesIdle = (double)time / 60000.0;
        return (long)((double)mem * Math.pow(2.0, minutesIdle / 15.0));
    }

    public static void main(String[] args) {
        for (int i = 0; i < 62; ++i) {
            System.out.printf("%d\t%d%n", i, LargestFirstMemoryManager.timeMemoryLoad(1L, (long)i * 60000L));
        }
    }
}

