/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.trace;

import java.io.IOException;
import java.io.InputStream;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.hadoop.fs.FSDataInputStream;

public class TraceFSDataInputStream
extends FSDataInputStream {
    private final FSDataInputStream impl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void seek(long desired) throws IOException {
        Span span = Trace.start((String)"FSDataInputStream.seek");
        try {
            this.impl.seek(desired);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        Span span = Trace.start((String)"FSDataInputStream.read");
        if (Trace.isTracing()) {
            span.data("length", Integer.toString(length));
        }
        try {
            int n = this.impl.read(position, buffer, offset, length);
            return n;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        Span span = Trace.start((String)"FSDataInputStream.readFully");
        if (Trace.isTracing()) {
            span.data("length", Integer.toString(length));
        }
        try {
            this.impl.readFully(position, buffer, offset, length);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully(long position, byte[] buffer) throws IOException {
        Span span = Trace.start((String)"FSDataInputStream.readFully");
        if (Trace.isTracing()) {
            span.data("length", Integer.toString(buffer.length));
        }
        try {
            this.impl.readFully(position, buffer);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean seekToNewSource(long targetPos) throws IOException {
        Span span = Trace.start((String)"FSDataInputStream.seekToNewSource");
        try {
            boolean bl = this.impl.seekToNewSource(targetPos);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    public TraceFSDataInputStream(FSDataInputStream in) throws IOException {
        super((InputStream)in);
        this.impl = in;
    }
}

