/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class AddFilesWithMissingEntries {
    static final Logger log = Logger.getLogger(AddFilesWithMissingEntries.class);

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(AddFilesWithMissingEntries.class.getName(), args, new Object[]{bwOpts});
        Scanner scanner = opts.getConnector().createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.setRange(MetadataSchema.TabletsSection.getRange());
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        KeyExtent last = new KeyExtent();
        String directory = null;
        HashSet<String> knownFiles = new HashSet<String>();
        int count = 0;
        MultiTableBatchWriter writer = opts.getConnector().createMultiTableBatchWriter(bwOpts.getBatchWriterConfig());
        for (Map.Entry entry : scanner) {
            Key key = (Key)entry.getKey();
            KeyExtent ke = new KeyExtent(key.getRow(), (Text)null);
            if (!ke.equals((Object)last)) {
                if (directory != null) {
                    count += AddFilesWithMissingEntries.addUnknownFiles(fs, directory, knownFiles, last, writer, opts.update);
                }
                directory = null;
                knownFiles.clear();
                last = ke;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) {
                directory = ((Value)entry.getValue()).toString();
                log.debug((Object)("Found directory " + directory + " for row " + key.getRow().toString()));
                continue;
            }
            if (key.compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) != 0) continue;
            String filename = key.getColumnQualifier().toString();
            knownFiles.add(filename);
            log.debug((Object)("METADATA file found: " + filename));
        }
        if (directory != null) {
            count += AddFilesWithMissingEntries.addUnknownFiles(fs, directory, knownFiles, last, writer, opts.update);
        }
        log.info((Object)("There were " + count + " files that are unknown to the metadata table"));
        writer.close();
    }

    private static int addUnknownFiles(FileSystem fs, String directory, Set<String> knownFiles, KeyExtent ke, MultiTableBatchWriter writer, boolean update) throws Exception {
        int count = 0;
        String tableId = ke.getTableId().toString();
        Text row = ke.getMetadataEntry();
        log.info((Object)row.toString());
        for (String dir : ServerConstants.getTablesDirs()) {
            Path path = new Path(dir + "/" + tableId + directory);
            for (FileStatus file : fs.listStatus(path)) {
                String filename;
                if (file.getPath().getName().endsWith("_tmp") || file.getPath().getName().endsWith("_tmp.rf") || knownFiles.contains(filename = directory + "/" + file.getPath().getName())) continue;
                ++count;
                Mutation m = new Mutation(row);
                String size = Long.toString(file.getLen());
                String entries = "1";
                String value = size + "," + entries;
                m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, new Text(filename), new Value(value.getBytes(Constants.UTF8)));
                if (!update) continue;
                writer.getBatchWriter("accumulo.metadata").addMutation(m);
            }
        }
        return count;
    }

    public static class Opts
    extends ClientOpts {
        @Parameter(names={"-update"}, description="Make changes to the accumulo.metadata table to include missing files")
        boolean update = false;
    }
}

