/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ChangeSecret {
    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ArrayList<String> argsList = new ArrayList<String>(args.length + 2);
        argsList.add("--old");
        argsList.add("--new");
        argsList.addAll(Arrays.asList(args));
        opts.parseArgs(ChangeSecret.class.getName(), argsList.toArray(new String[0]), new Object[0]);
        VolumeManager fs = VolumeManagerImpl.get();
        Instance inst = opts.getInstance();
        if (!ChangeSecret.verifyAccumuloIsDown(inst, opts.oldPass)) {
            System.exit(-1);
        }
        String instanceId = ChangeSecret.rewriteZooKeeperInstance(inst, opts.oldPass, opts.newPass);
        ChangeSecret.updateHdfs(fs, inst, instanceId);
        if (opts.oldPass != null) {
            ChangeSecret.deleteInstance(inst, opts.oldPass);
        }
        System.out.println("New instance id is " + instanceId);
        System.out.println("Be sure to put your new secret in accumulo-site.xml");
    }

    private static void recurse(ZooReader zoo, String root, Visitor v) {
        try {
            v.visit(zoo, root);
            for (String child : zoo.getChildren(root)) {
                ChangeSecret.recurse(zoo, root + "/" + child, v);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean verifyAccumuloIsDown(Instance inst, String oldPassword) {
        ZooReaderWriter zooReader = new ZooReaderWriter(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut(), oldPassword);
        String root = ZooUtil.getRoot((Instance)inst);
        final ArrayList ephemerals = new ArrayList();
        ChangeSecret.recurse((ZooReader)zooReader, root, new Visitor(){

            @Override
            public void visit(ZooReader zoo, String path) throws Exception {
                Stat stat = zoo.getStatus(path);
                if (stat.getEphemeralOwner() != 0L) {
                    ephemerals.add(path);
                }
            }
        });
        if (ephemerals.size() == 0) {
            return true;
        }
        System.err.println("The following ephemeral nodes exist, something is still running:");
        for (String path : ephemerals) {
            System.err.println(path);
        }
        return false;
    }

    private static String rewriteZooKeeperInstance(final Instance inst, String oldPass, String newPass) throws Exception {
        final ZooReaderWriter orig = new ZooReaderWriter(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut(), oldPass);
        ZooReaderWriter new_ = new ZooReaderWriter(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut(), newPass);
        final String newInstanceId = UUID.randomUUID().toString();
        String root = ZooUtil.getRoot((Instance)inst);
        ChangeSecret.recurse((ZooReader)orig, root, new Visitor((IZooReaderWriter)new_){
            final /* synthetic */ IZooReaderWriter val$new_;
            {
                this.val$new_ = iZooReaderWriter;
            }

            @Override
            public void visit(ZooReader zoo, String path) throws Exception {
                String newPath = path.replace(inst.getInstanceID(), newInstanceId);
                byte[] data = zoo.getData(path, null);
                List acls = orig.getZooKeeper().getACL(path, new Stat());
                if (acls.containsAll(ZooDefs.Ids.READ_ACL_UNSAFE)) {
                    this.val$new_.putPersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                } else if (acls.containsAll(ZooDefs.Ids.OPEN_ACL_UNSAFE)) {
                    String[] parts = path.split("/");
                    if (parts[parts.length - 2].equals("users")) {
                        this.val$new_.putPrivatePersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                    } else {
                        this.val$new_.putPersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                    }
                } else {
                    this.val$new_.putPrivatePersistentData(newPath, data, ZooUtil.NodeExistsPolicy.FAIL);
                }
            }
        });
        String path = "/accumulo/instances/" + inst.getInstanceName();
        orig.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
        new_.putPersistentData(path, newInstanceId.getBytes(Constants.UTF8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return newInstanceId;
    }

    private static void updateHdfs(VolumeManager fs, Instance inst, String newInstanceId) throws IOException {
        for (Volume v : fs.getVolumes()) {
            Path instanceId = ServerConstants.getInstanceIdLocation(v);
            if (!v.getFileSystem().delete(instanceId, true)) {
                throw new IOException("Could not recursively delete " + instanceId);
            }
            if (!v.getFileSystem().mkdirs(instanceId)) {
                throw new IOException("Could not create directory " + instanceId);
            }
            v.getFileSystem().create(new Path(instanceId, newInstanceId)).close();
        }
    }

    private static void deleteInstance(Instance origInstance, String oldPass) throws Exception {
        ZooReaderWriter orig = new ZooReaderWriter(origInstance.getZooKeepers(), origInstance.getZooKeepersSessionTimeOut(), oldPass);
        orig.recursiveDelete("/accumulo/" + origInstance.getInstanceID(), ZooUtil.NodeMissingPolicy.SKIP);
    }

    static interface Visitor {
        public void visit(ZooReader var1, String var2) throws Exception;
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--old"}, description="old zookeeper password", password=true, hidden=true)
        String oldPass;
        @Parameter(names={"--new"}, description="new zookeeper password", password=true, hidden=true)
        String newPass;

        Opts() {
        }
    }
}

