/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class FindOfflineTablets {
    private static final Logger log = Logger.getLogger(FindOfflineTablets.class);

    public static void main(String[] args) throws Exception {
        ClientOpts opts = new ClientOpts();
        opts.parseArgs(FindOfflineTablets.class.getName(), args, new Object[0]);
        Instance instance = opts.getInstance();
        SystemCredentials creds = SystemCredentials.get();
        FindOfflineTablets.findOffline(instance, creds, null);
    }

    static int findOffline(Instance instance, Credentials creds, String tableName) throws AccumuloException, TableNotFoundException {
        Iterator zooScanner;
        final AtomicBoolean scanning = new AtomicBoolean(false);
        LiveTServerSet tservers = new LiveTServerSet(instance, (AccumuloConfiguration)DefaultConfiguration.getDefaultConfiguration(), new LiveTServerSet.Listener(){

            @Override
            public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
                if (!deleted.isEmpty() && scanning.get()) {
                    log.warn((Object)("Tablet servers deleted while scanning: " + deleted));
                }
                if (!added.isEmpty() && scanning.get()) {
                    log.warn((Object)("Tablet servers added while scanning: " + added));
                }
            }
        });
        tservers.startListeningForTabletServerChanges();
        scanning.set(true);
        try {
            zooScanner = new ZooTabletStateStore().iterator();
        }
        catch (DistributedStoreException e) {
            throw new AccumuloException((Throwable)e);
        }
        int offline = 0;
        System.out.println("Scanning zookeeper");
        offline = FindOfflineTablets.checkTablets(zooScanner, tservers);
        if (offline > 0) {
            return offline;
        }
        if ("accumulo.root".equals(tableName)) {
            return 0;
        }
        System.out.println("Scanning accumulo.root");
        MetaDataTableScanner rootScanner = new MetaDataTableScanner(instance, creds, MetadataSchema.TabletsSection.getRange(), "accumulo.root");
        offline = FindOfflineTablets.checkTablets(rootScanner, tservers);
        if (offline > 0) {
            return offline;
        }
        if ("accumulo.metadata".equals(tableName)) {
            return 0;
        }
        System.out.println("Scanning accumulo.metadata");
        Range range = MetadataSchema.TabletsSection.getRange();
        if (tableName != null) {
            String tableId = Tables.getTableId((Instance)instance, (String)tableName);
            range = new KeyExtent(new Text(tableId), null, null).toMetadataRange();
        }
        MetaDataTableScanner metaScanner = new MetaDataTableScanner(instance, creds, range, "accumulo.metadata");
        return FindOfflineTablets.checkTablets(metaScanner, tservers);
    }

    private static int checkTablets(Iterator<TabletLocationState> scanner, LiveTServerSet tservers) {
        int offline = 0;
        while (scanner.hasNext() && !System.out.checkError()) {
            TabletLocationState locationState = scanner.next();
            TabletState state = locationState.getState(tservers.getCurrentServers());
            if (state == null || state == TabletState.HOSTED || TableManager.getInstance().getTableState(locationState.extent.getTableId().toString()) == TableState.OFFLINE) continue;
            System.out.println(locationState + " is " + (Object)((Object)state) + "  #walogs:" + locationState.walogs.size());
            ++offline;
        }
        return offline;
    }
}

