/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class MasterMetadataUtil {
    private static final Logger log = Logger.getLogger(MasterMetadataUtil.class);

    public static void addNewTablet(KeyExtent extent, String path, TServerInstance location, Map<FileRef, DataFileValue> datafileSizes, Map<FileRef, Long> bulkLoadedFiles, Credentials credentials, String time, long lastFlushID, long lastCompactID, ZooLock zooLock) {
        Mutation m = extent.getPrevRowUpdateMutation();
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(m, new Value(path.getBytes()));
        MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes()));
        if (lastFlushID > 0L) {
            MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value(("" + lastFlushID).getBytes()));
        }
        if (lastCompactID > 0L) {
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value(("" + lastCompactID).getBytes()));
        }
        if (location != null) {
            m.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, location.asColumnQualifier(), location.asMutationValue());
            m.putDelete(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME, location.asColumnQualifier());
        }
        for (Map.Entry<FileRef, DataFileValue> entry : datafileSizes.entrySet()) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, entry.getKey().meta(), new Value(entry.getValue().encode()));
        }
        for (Map.Entry<FileRef, Object> entry : bulkLoadedFiles.entrySet()) {
            byte[] tidBytes = Long.toString((Long)entry.getValue()).getBytes();
            m.put(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME, entry.getKey().meta(), new Value(tidBytes));
        }
        MetadataTableUtil.update(credentials, zooLock, m, extent);
    }

    public static KeyExtent fixSplit(Text metadataEntry, SortedMap<ColumnFQ, Value> columns, TServerInstance tserver, Credentials credentials, ZooLock lock) throws AccumuloException, IOException {
        log.info((Object)("Incomplete split " + metadataEntry + " attempting to fix"));
        Value oper = (Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN);
        if (columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN) == null) {
            throw new IllegalArgumentException("Metadata entry does not have split ratio (" + metadataEntry + ")");
        }
        double splitRatio = Double.parseDouble(new String(((Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN)).get()));
        Value prevEndRowIBW = (Value)columns.get(MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN);
        if (prevEndRowIBW == null) {
            throw new IllegalArgumentException("Metadata entry does not have prev row (" + metadataEntry + ")");
        }
        Value time = (Value)columns.get(MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
        if (time == null) {
            throw new IllegalArgumentException("Metadata entry does not have time (" + metadataEntry + ")");
        }
        Value flushID = (Value)columns.get(MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN);
        long initFlushID = -1L;
        if (flushID != null) {
            initFlushID = Long.parseLong(flushID.toString());
        }
        Value compactID = (Value)columns.get(MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN);
        long initCompactID = -1L;
        if (compactID != null) {
            initCompactID = Long.parseLong(compactID.toString());
        }
        Text metadataPrevEndRow = KeyExtent.decodePrevEndRow((Value)prevEndRowIBW);
        Text table = new KeyExtent(metadataEntry, (Text)null).getTableId();
        return MasterMetadataUtil.fixSplit(table, metadataEntry, metadataPrevEndRow, oper, splitRatio, tserver, credentials, time.toString(), initFlushID, initCompactID, lock);
    }

    private static KeyExtent fixSplit(Text table, Text metadataEntry, Text metadataPrevEndRow, Value oper, double splitRatio, TServerInstance tserver, Credentials credentials, String time, long initFlushID, long initCompactID, ZooLock lock) throws AccumuloException, IOException {
        if (metadataPrevEndRow == null) {
            throw new AccumuloException("Split tablet does not have prev end row, something is amiss, extent = " + metadataEntry);
        }
        Key prevRowKey = new Key(new Text(KeyExtent.getMetadataEntry((Text)table, (Text)metadataPrevEndRow)));
        ScannerImpl scanner2 = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Authorizations.EMPTY);
        scanner2.setRange(new Range(prevRowKey, prevRowKey.followingKey(PartialKey.ROW)));
        VolumeManager fs = VolumeManagerImpl.get();
        if (!scanner2.iterator().hasNext()) {
            log.info((Object)("Rolling back incomplete split " + metadataEntry + " " + metadataPrevEndRow));
            MetadataTableUtil.rollBackSplit(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper), credentials, lock);
            return new KeyExtent(metadataEntry, KeyExtent.decodePrevEndRow((Value)oper));
        }
        log.info((Object)("Finishing incomplete split " + metadataEntry + " " + metadataPrevEndRow));
        ArrayList<FileRef> highDatafilesToRemove = new ArrayList<FileRef>();
        ScannerImpl scanner3 = new ScannerImpl(HdfsZooInstance.getInstance(), credentials, "!0", Authorizations.EMPTY);
        Key rowKey = new Key(metadataEntry);
        TreeMap<FileRef, DataFileValue> origDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        TreeMap<FileRef, DataFileValue> highDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        TreeMap<FileRef, DataFileValue> lowDatafileSizes = new TreeMap<FileRef, DataFileValue>();
        scanner3.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        scanner3.setRange(new Range(rowKey, rowKey.followingKey(PartialKey.ROW)));
        for (Map.Entry entry : scanner3) {
            if (((Key)entry.getKey()).compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) != 0) continue;
            origDatafileSizes.put(new FileRef(fs, (Key)entry.getKey()), new DataFileValue(((Value)entry.getValue()).get()));
        }
        MetadataTableUtil.splitDatafiles(table, metadataPrevEndRow, splitRatio, new HashMap<FileRef, FileUtil.FileInfo>(), origDatafileSizes, lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
        MetadataTableUtil.finishSplit(metadataEntry, highDatafileSizes, highDatafilesToRemove, credentials, lock);
        return new KeyExtent(metadataEntry, KeyExtent.encodePrevEndRow((Text)metadataPrevEndRow));
    }

    private static TServerInstance getTServerInstance(String address, ZooLock zooLock) {
        while (true) {
            try {
                return new TServerInstance(address, zooLock.getSessionId());
            }
            catch (KeeperException e) {
                log.error((Object)e, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error((Object)e, (Throwable)e);
            }
            UtilWaitThread.sleep((long)1000L);
        }
    }

    public static void replaceDatafiles(KeyExtent extent, Set<FileRef> datafilesToDelete, Set<FileRef> scanFiles, FileRef path, Long compactionId, DataFileValue size, Credentials credentials, String address, TServerInstance lastLocation, ZooLock zooLock) throws IOException {
        MasterMetadataUtil.replaceDatafiles(extent, datafilesToDelete, scanFiles, path, compactionId, size, credentials, address, lastLocation, zooLock, true);
    }

    public static void replaceDatafiles(KeyExtent extent, Set<FileRef> datafilesToDelete, Set<FileRef> scanFiles, FileRef path, Long compactionId, DataFileValue size, Credentials credentials, String address, TServerInstance lastLocation, ZooLock zooLock, boolean insertDeleteFlags) throws IOException {
        if (insertDeleteFlags) {
            MetadataTableUtil.addDeleteEntries(extent, datafilesToDelete, credentials);
        }
        Mutation m = new Mutation(extent.getMetadataEntry());
        for (FileRef pathToRemove : datafilesToDelete) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, pathToRemove.meta());
        }
        for (FileRef scanFile : scanFiles) {
            m.put(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, scanFile.meta(), new Value("".getBytes()));
        }
        if (size.getNumEntries() > 0L) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.meta(), new Value(size.encode()));
        }
        if (compactionId != null) {
            MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.put(m, new Value(("" + compactionId).getBytes()));
        }
        TServerInstance self = MasterMetadataUtil.getTServerInstance(address, zooLock);
        self.putLastLocation(m);
        if (lastLocation != null && !lastLocation.equals(self)) {
            lastLocation.clearLastLocation(m);
        }
        MetadataTableUtil.update(credentials, zooLock, m, extent);
    }

    public static void updateTabletDataFile(KeyExtent extent, FileRef path, FileRef mergeFile, DataFileValue dfv, String time, Credentials credentials, Set<FileRef> filesInUseByScans, String address, ZooLock zooLock, Set<String> unusedWalLogs, TServerInstance lastLocation, long flushId) {
        if (extent.isRootTablet()) {
            if (unusedWalLogs != null) {
                ZooReaderWriter zk = ZooReaderWriter.getInstance();
                String root = MetadataTableUtil.getZookeeperLogLocation();
                boolean foundEntry = false;
                block3: for (String entry : unusedWalLogs) {
                    String[] parts = entry.split("/");
                    String zpath = root + "/" + parts[parts.length - 1];
                    while (true) {
                        try {
                            if (!zk.exists(zpath)) continue block3;
                            zk.recursiveDelete(zpath, ZooUtil.NodeMissingPolicy.SKIP);
                            foundEntry = true;
                            continue block3;
                        }
                        catch (KeeperException e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e, (Throwable)e);
                        }
                        UtilWaitThread.sleep((long)1000L);
                    }
                }
                if (unusedWalLogs.size() > 0 && !foundEntry) {
                    log.warn((Object)("WALog entry for root tablet did not exist " + unusedWalLogs));
                }
            }
            return;
        }
        Mutation m = new Mutation(extent.getMetadataEntry());
        if (dfv.getNumEntries() > 0L) {
            m.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, path.meta(), new Value(dfv.encode()));
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(time.getBytes()));
            TServerInstance self = MasterMetadataUtil.getTServerInstance(address, zooLock);
            self.putLastLocation(m);
            if (lastLocation != null && !lastLocation.equals(self)) {
                lastLocation.clearLastLocation(m);
            }
        }
        if (unusedWalLogs != null) {
            for (String entry : unusedWalLogs) {
                m.putDelete(MetadataSchema.TabletsSection.LogColumnFamily.NAME, new Text(entry));
            }
        }
        for (FileRef scanFile : filesInUseByScans) {
            m.put(MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME, scanFile.meta(), new Value("".getBytes()));
        }
        if (mergeFile != null) {
            m.putDelete(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, mergeFile.meta());
        }
        MetadataSchema.TabletsSection.ServerColumnFamily.FLUSH_COLUMN.put(m, new Value((flushId + "").getBytes()));
        MetadataTableUtil.update(credentials, zooLock, m, extent);
    }
}

