/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.accumulo.core.util.TBufferedSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TBufferedServerSocket
extends TServerTransport {
    final TServerSocket impl;
    final int bufferSize;

    public TBufferedServerSocket(ServerSocket serverSocket, int bufferSize) {
        this.impl = new TServerSocket(serverSocket);
        this.bufferSize = bufferSize;
    }

    public void listen() throws TTransportException {
        this.impl.listen();
    }

    public void close() {
        this.impl.close();
    }

    protected TTransport acceptImpl() throws TTransportException {
        TSocket sock = this.impl.acceptImplPublic();
        try {
            return new TBufferedSocket(sock, this.bufferSize);
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    static class TServerSocket
    extends org.apache.thrift.transport.TServerSocket {
        public TServerSocket(ServerSocket serverSocket) {
            super(serverSocket);
        }

        public TSocket acceptImplPublic() throws TTransportException {
            return this.acceptImpl();
        }
    }
}

