/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class TabletIterator
implements Iterator<Map<Key, Value>> {
    private static final Logger log = Logger.getLogger(TabletIterator.class);
    private SortedMap<Key, Value> currentTabletKeys;
    private Text lastTablet;
    private Scanner scanner;
    private Iterator<Map.Entry<Key, Value>> iter;
    private boolean returnPrevEndRow;
    private boolean returnDir;
    private Range range;

    public TabletIterator(Scanner s, Range range, boolean returnPrevEndRow, boolean returnDir) {
        this.scanner = s;
        this.range = range;
        this.scanner.setRange(range);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)this.scanner);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)this.scanner);
        this.iter = s.iterator();
        this.returnPrevEndRow = returnPrevEndRow;
        this.returnDir = returnDir;
    }

    @Override
    public boolean hasNext() {
        while (this.currentTabletKeys == null) {
            boolean perEqual;
            Text lastEndRow;
            this.currentTabletKeys = this.scanToPrevEndRow();
            if (this.currentTabletKeys.size() == 0) break;
            Key prevEndRowKey = this.currentTabletKeys.lastKey();
            Value prevEndRowValue = (Value)this.currentTabletKeys.get(prevEndRowKey);
            if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(prevEndRowKey)) {
                log.debug(this.currentTabletKeys);
                throw new RuntimeException("Unexpected key " + prevEndRowKey);
            }
            Text per = KeyExtent.decodePrevEndRow((Value)prevEndRowValue);
            if (this.lastTablet == null) {
                lastEndRow = null;
            } else {
                String currentTable;
                lastEndRow = new KeyExtent(this.lastTablet, (Text)null).getEndRow();
                String lastTable = new KeyExtent(this.lastTablet, (Text)null).getTableId().toString();
                if (!(lastTable.equals(currentTable = new KeyExtent(prevEndRowKey.getRow(), (Text)null).getTableId().toString()) || per == null && lastEndRow == null)) {
                    log.info((Object)("Metadata inconsistency on table transition : " + lastTable + " " + currentTable + " " + per + " " + lastEndRow));
                    this.currentTabletKeys = null;
                    this.resetScanner();
                    UtilWaitThread.sleep((long)250L);
                    continue;
                }
            }
            boolean bl = perEqual = per == null && lastEndRow == null || per != null && lastEndRow != null && per.equals((Object)lastEndRow);
            if (!perEqual) {
                log.info((Object)("Metadata inconsistency : " + per + " != " + lastEndRow + " metadataKey = " + prevEndRowKey));
                this.currentTabletKeys = null;
                this.resetScanner();
                UtilWaitThread.sleep((long)250L);
                continue;
            }
            this.lastTablet = prevEndRowKey.getRow();
        }
        return this.currentTabletKeys.size() > 0;
    }

    @Override
    public Map<Key, Value> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SortedMap<Key, Value> tmp = this.currentTabletKeys;
        this.currentTabletKeys = null;
        Set es = tmp.entrySet();
        Iterator esIter = es.iterator();
        while (esIter.hasNext()) {
            Map.Entry entry = esIter.next();
            if (!this.returnPrevEndRow && MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns((Key)entry.getKey())) {
                esIter.remove();
            }
            if (this.returnDir || !MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns((Key)entry.getKey())) continue;
            esIter.remove();
        }
        return tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private SortedMap<Key, Value> scanToPrevEndRow() {
        Text curMetaDataRow = null;
        TreeMap<Key, Value> tm = new TreeMap<Key, Value>();
        boolean sawPrevEndRow = false;
        while (true) {
            if (this.iter.hasNext()) {
                Map.Entry<Key, Value> entry = this.iter.next();
                if (curMetaDataRow == null) {
                    curMetaDataRow = entry.getKey().getRow();
                }
                if (curMetaDataRow.equals((Object)entry.getKey().getRow())) {
                    tm.put(entry.getKey(), entry.getValue());
                    if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(entry.getKey())) continue;
                    sawPrevEndRow = true;
                }
            }
            if (sawPrevEndRow || tm.size() <= 0) break;
            log.warn((Object)("Metadata problem : tablet " + curMetaDataRow + " has no prev end row"));
            this.resetScanner();
            curMetaDataRow = null;
            tm.clear();
            UtilWaitThread.sleep((long)250L);
        }
        return tm;
    }

    protected void resetScanner() {
        Range range;
        if (this.lastTablet == null) {
            range = this.range;
        } else {
            range = new Range(this.lastTablet, true, this.lastTablet, true);
            this.scanner.setRange(range);
            int count = 0;
            for (Map.Entry entry : this.scanner) {
                ++count;
            }
            if (count == 0) {
                throw new TabletDeletedException("Tablet " + this.lastTablet + " was deleted while iterating");
            }
            range = new Range(new Key(this.lastTablet).followingKey(PartialKey.ROW), true, this.range.getEndKey(), this.range.isEndKeyInclusive());
        }
        log.info((Object)("Resetting accumulo.metadata scanner to " + range));
        this.scanner.setRange(range);
        this.iter = this.scanner.iterator();
    }

    public static class TabletDeletedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TabletDeletedException(String msg) {
            super(msg);
        }
    }
}

