/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.watcher;

import com.google.common.net.HostAndPort;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class MonitorLog4jWatcher
extends FileWatchdog
implements Watcher {
    private static final Logger log = Logger.getLogger(MonitorLog4jWatcher.class);
    private static final String HOST_PROPERTY_NAME = "org.apache.accumulo.core.host.log";
    private static final String PORT_PROPERTY_NAME = "org.apache.accumulo.core.host.log.port";
    private final Object lock;
    private boolean loggingDisabled = false;
    protected String path;

    public MonitorLog4jWatcher(String instance, String filename, int delay) {
        super(filename);
        this.setDelay(delay);
        this.path = ZooUtil.getRoot((String)instance) + "/monitor/log4j_addr";
        this.lock = new Object();
    }

    public void run() {
        try {
            if (ZooReaderWriter.getInstance().exists(this.path, this)) {
                this.updateMonitorLog4jLocation();
            }
            log.info((Object)"Set watch for Monitor Log4j watcher");
        }
        catch (Exception e) {
            log.error((Object)("Unable to set watch for Monitor Log4j watcher on " + this.path));
        }
        super.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOnChange() {
        if (null == this.lock) {
            this.resetLogger();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.loggingDisabled = false;
            log.info((Object)"Enabled log-forwarding");
            this.resetLogger();
        }
    }

    private void resetLogger() {
        LogManager.resetConfiguration();
        new DOMConfigurator().doConfigure(this.filename, LogManager.getLoggerRepository());
    }

    public void process(WatchedEvent event) {
        this.updateMonitorLog4jLocation();
        if (event.getPath() != null) {
            try {
                ZooReaderWriter.getInstance().exists(event.getPath(), this);
            }
            catch (Exception ex) {
                log.error((Object)"Unable to reset watch for Monitor Log4j watcher", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMonitorLog4jLocation() {
        try {
            String hostPortString = new String(ZooReaderWriter.getInstance().getData(this.path, null), Constants.UTF8);
            HostAndPort hostAndPort = HostAndPort.fromString((String)hostPortString);
            System.setProperty(HOST_PROPERTY_NAME, hostAndPort.getHostText());
            System.setProperty(PORT_PROPERTY_NAME, Integer.toString(hostAndPort.getPort()));
            log.info((Object)("Changing monitor log4j address to " + hostAndPort.toString()));
            this.doOnChange();
        }
        catch (KeeperException.NoNodeException e) {
            Object object = this.lock;
            synchronized (object) {
                Appender appender;
                if (this.loggingDisabled) {
                    return;
                }
                Logger logger = LogManager.getLogger((String)"org.apache.accumulo");
                if (null != logger && null != (appender = logger.getAppender("ASYNC"))) {
                    log.info((Object)"Closing log-forwarding appender");
                    appender.close();
                    log.info((Object)"Removing log-forwarding appender");
                    logger.removeAppender(appender);
                    this.loggingDisabled = true;
                }
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Could not parse host and port information", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error reading zookeeper data for Monitor Log4j watcher", (Throwable)e);
        }
    }
}

