/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class ZooReaderWriter
extends org.apache.accumulo.fate.zookeeper.ZooReaderWriter {
    private static final String SCHEME = "digest";
    private static final String USER = "accumulo";
    private static ZooReaderWriter instance = null;
    private static IZooReaderWriter retryingInstance = null;

    public ZooReaderWriter(String string, int timeInMillis, String secret) {
        super(string, timeInMillis, SCHEME, ("accumulo:" + secret).getBytes(Constants.UTF8));
    }

    public static synchronized ZooReaderWriter getInstance() {
        if (instance == null) {
            SiteConfiguration conf = ServerConfiguration.getSiteConfiguration();
            instance = new ZooReaderWriter(conf.get(Property.INSTANCE_ZK_HOST), (int)conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT), conf.get(Property.INSTANCE_SECRET));
        }
        return instance;
    }

    public static synchronized IZooReaderWriter getRetryingInstance() {
        if (retryingInstance == null) {
            ZooReaderWriter inst = ZooReaderWriter.getInstance();
            InvocationHandler ih = new InvocationHandler((IZooReaderWriter)inst){
                final /* synthetic */ IZooReaderWriter val$inst;
                {
                    this.val$inst = iZooReaderWriter;
                }

                @Override
                public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                    long retryTime = 250L;
                    while (true) {
                        try {
                            return method.invoke((Object)this.val$inst, args);
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() instanceof KeeperException.ConnectionLossException) {
                                Logger.getLogger(ZooReaderWriter.class).warn((Object)("Error connecting to zookeeper, will retry in " + retryTime), e.getCause());
                                UtilWaitThread.sleep((long)retryTime);
                                retryTime = Math.min(5000L, retryTime + 250L);
                                continue;
                            }
                            throw e.getCause();
                        }
                        break;
                    }
                }
            };
            retryingInstance = (IZooReaderWriter)Proxy.newProxyInstance(ZooReaderWriter.class.getClassLoader(), new Class[]{IZooReaderWriter.class}, ih);
        }
        return retryingInstance;
    }
}

