/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.hadoop.fs.Path;

public class ServerConstants {
    public static final String VERSION_DIR = "version";
    public static final String INSTANCE_ID_DIR = "instance_id";
    public static final Integer WIRE_VERSION = 3;
    public static final int DATA_VERSION = 6;
    public static final int PREV_DATA_VERSION = 5;
    public static final int TWO_DATA_VERSIONS_AGO = 4;
    private static String[] baseUris = null;
    private static List<Pair<Path, Path>> replacementsList = null;
    public static final String TABLE_DIR = "tables";
    public static final String RECOVERY_DIR = "recovery";
    public static final String WAL_DIR = "wal";
    public static final String WALOG_ARCHIVE_DIR = "walogArchive";
    public static final String FILE_ARCHIVE_DIR = "fileArchive";

    public static synchronized String[] getBaseUris() {
        if (baseUris == null) {
            baseUris = ServerConstants.checkBaseUris(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()), false);
        }
        return baseUris;
    }

    public static String[] checkBaseUris(String[] configuredBaseDirs, boolean ignore) {
        String firstDir = null;
        String firstIid = null;
        Integer firstVersion = null;
        ArrayList<String> baseDirsList = new ArrayList<String>();
        for (String baseDir : configuredBaseDirs) {
            Integer currentVersion;
            String currentIid;
            Path path = new Path(baseDir, INSTANCE_ID_DIR);
            try {
                currentIid = ZooUtil.getInstanceIDFromHdfs((Path)path, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
                Path vpath = new Path(baseDir, VERSION_DIR);
                currentVersion = Accumulo.getAccumuloPersistentVersion(vpath.getFileSystem(CachedConfiguration.getInstance()), vpath);
            }
            catch (Exception e) {
                if (ignore) continue;
                throw new IllegalArgumentException("Accumulo volume " + path + " not initialized", e);
            }
            if (firstIid == null) {
                firstIid = currentIid;
                firstDir = baseDir;
                firstVersion = currentVersion;
            } else {
                if (!currentIid.equals(firstIid)) {
                    throw new IllegalArgumentException("Configuration " + Property.INSTANCE_VOLUMES.getKey() + " contains paths that have different instance ids " + baseDir + " has " + currentIid + " and " + firstDir + " has " + firstIid);
                }
                if (!currentVersion.equals(firstVersion)) {
                    throw new IllegalArgumentException("Configuration " + Property.INSTANCE_VOLUMES.getKey() + " contains paths that have different versions " + baseDir + " has " + currentVersion + " and " + firstDir + " has " + firstVersion);
                }
            }
            baseDirsList.add(baseDir);
        }
        if (baseDirsList.size() == 0) {
            throw new RuntimeException("None of the configured paths are initialized.");
        }
        return baseDirsList.toArray(new String[baseDirsList.size()]);
    }

    public static String[] getTablesDirs() {
        return VolumeConfiguration.prefix((String[])ServerConstants.getBaseUris(), (String)TABLE_DIR);
    }

    public static String[] getRecoveryDirs() {
        return VolumeConfiguration.prefix((String[])ServerConstants.getBaseUris(), (String)RECOVERY_DIR);
    }

    public static String[] getWalDirs() {
        return VolumeConfiguration.prefix((String[])ServerConstants.getBaseUris(), (String)WAL_DIR);
    }

    public static String[] getWalogArchives() {
        return VolumeConfiguration.prefix((String[])ServerConstants.getBaseUris(), (String)WALOG_ARCHIVE_DIR);
    }

    public static String[] getFileArchives() {
        return VolumeConfiguration.prefix((String[])ServerConstants.getBaseUris(), (String)FILE_ARCHIVE_DIR);
    }

    public static Path getInstanceIdLocation(Volume v) {
        return v.prefixChild(INSTANCE_ID_DIR);
    }

    public static Path getDataVersionLocation(Volume v) {
        return v.prefixChild(VERSION_DIR);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized List<Pair<Path, Path>> getVolumeReplacements() {
        if (replacementsList == null) {
            void var5_7;
            String replacements = ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_VOLUMES_REPLACEMENTS);
            if ((replacements = replacements.trim()).isEmpty()) {
                return Collections.emptyList();
            }
            String[] pairs = replacements.split(",");
            ArrayList<Pair<Path, Path>> ret = new ArrayList<Pair<Path, Path>>();
            String[] arr$ = pairs;
            int len$ = arr$.length;
            boolean bl = false;
            while (var5_7 < len$) {
                Path p2;
                Path p1;
                String pair = arr$[var5_7];
                String[] uris = pair.split("\\s+");
                if (uris.length != 2) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains malformed pair " + pair);
                }
                try {
                    p1 = new Path(new URI(VolumeUtil.removeTrailingSlash(uris[0].trim())));
                    if (p1.toUri().getScheme() == null) {
                        throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[0] + " which is not fully qualified");
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[0] + " which has a syntax error", e);
                }
                try {
                    p2 = new Path(new URI(VolumeUtil.removeTrailingSlash(uris[1].trim())));
                    if (p2.toUri().getScheme() == null) {
                        throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[1] + " which is not fully qualified");
                    }
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + uris[1] + " which has a syntax error", e);
                }
                ret.add((Pair<Path, Path>)new Pair((Object)p1, (Object)p2));
                ++var5_7;
            }
            HashSet<Path> baseDirs = new HashSet<Path>();
            for (String baseDir : ServerConstants.getBaseUris()) {
                baseDirs.add(new Path(baseDir));
            }
            for (Pair pair : ret) {
                if (baseDirs.contains(pair.getSecond())) continue;
                throw new IllegalArgumentException(Property.INSTANCE_VOLUMES_REPLACEMENTS.getKey() + " contains " + pair.getSecond() + " which is not a configured volume");
            }
            replacementsList = ret;
        }
        return replacementsList;
    }
}

