/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ConfigurationType;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.TDiskUsage;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.client.BulkImporter;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.util.TableDiskUsage;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.trace.thrift.TInfo;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class ClientServiceHandler
implements ClientService.Iface {
    private static final Logger log = Logger.getLogger(ClientServiceHandler.class);
    private static SecurityOperation security = AuditedSecurityOperation.getInstance();
    protected final TransactionWatcher transactionWatcher;
    private final Instance instance;
    private final VolumeManager fs;

    public ClientServiceHandler(Instance instance, TransactionWatcher transactionWatcher, VolumeManager fs) {
        this.instance = instance;
        this.transactionWatcher = transactionWatcher;
        this.fs = fs;
    }

    public static String checkTableId(Instance instance, String tableName, TableOperation operation) throws ThriftTableOperationException {
        TableOperationExceptionType reason = null;
        try {
            return Tables._getTableId((Instance)instance, (String)tableName);
        }
        catch (NamespaceNotFoundException e) {
            reason = TableOperationExceptionType.NAMESPACE_NOTFOUND;
        }
        catch (TableNotFoundException e) {
            reason = TableOperationExceptionType.NOTFOUND;
        }
        throw new ThriftTableOperationException(null, tableName, operation, reason, null);
    }

    public static String checkNamespaceId(Instance instance, String namespace, TableOperation operation) throws ThriftTableOperationException {
        String namespaceId = (String)Namespaces.getNameToIdMap((Instance)instance).get(namespace);
        if (namespaceId == null) {
            Tables.clearCache((Instance)instance);
            namespaceId = (String)Namespaces.getNameToIdMap((Instance)instance).get(namespace);
            if (namespaceId == null) {
                throw new ThriftTableOperationException(null, namespace, operation, TableOperationExceptionType.NAMESPACE_NOTFOUND, null);
            }
        }
        return namespaceId;
    }

    public String getInstanceId() {
        return this.instance.getInstanceID();
    }

    public String getRootTabletLocation() {
        return this.instance.getRootTabletLocation();
    }

    public String getZooKeepers() {
        return this.instance.getZooKeepers();
    }

    public void ping(TCredentials credentials) {
        log.info((Object)"Master reports: I just got pinged!");
    }

    public boolean authenticate(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        try {
            return security.authenticateUser(credentials, credentials);
        }
        catch (ThriftSecurityException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public boolean authenticateUser(TInfo tinfo, TCredentials credentials, TCredentials toAuth) throws ThriftSecurityException {
        try {
            return security.authenticateUser(credentials, toAuth);
        }
        catch (ThriftSecurityException e) {
            log.error((Object)e);
            throw e;
        }
    }

    public void changeAuthorizations(TInfo tinfo, TCredentials credentials, String user, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        security.changeAuthorizations(credentials, user, new Authorizations(authorizations));
    }

    public void changeLocalUserPassword(TInfo tinfo, TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException {
        PasswordToken token = new PasswordToken(password);
        Credentials toChange = new Credentials(principal, (AuthenticationToken)token);
        security.changePassword(credentials, toChange);
    }

    public void createLocalUser(TInfo tinfo, TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException {
        PasswordToken token = new PasswordToken(password);
        Credentials newUser = new Credentials(principal, (AuthenticationToken)token);
        security.createUser(credentials, newUser, new Authorizations());
    }

    public void dropLocalUser(TInfo tinfo, TCredentials credentials, String user) throws ThriftSecurityException {
        security.dropUser(credentials, user);
    }

    public List<ByteBuffer> getUserAuthorizations(TInfo tinfo, TCredentials credentials, String user) throws ThriftSecurityException {
        return security.getUserAuthorizations(credentials, user).getAuthorizationsBB();
    }

    public void grantSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte permission) throws ThriftSecurityException {
        security.grantSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)permission));
    }

    public void grantTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        String tableId = ClientServiceHandler.checkTableId(this.instance, tableName, TableOperation.PERMISSION);
        String namespaceId = Tables.getNamespaceId((Instance)this.instance, (String)tableId);
        security.grantTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)permission), namespaceId);
    }

    public void grantNamespacePermission(TInfo tinfo, TCredentials credentials, String user, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId = ClientServiceHandler.checkNamespaceId(this.instance, ns, TableOperation.PERMISSION);
        security.grantNamespacePermission(credentials, user, namespaceId, NamespacePermission.getPermissionById((byte)permission));
    }

    public void revokeSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte permission) throws ThriftSecurityException {
        security.revokeSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)permission));
    }

    public void revokeTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        String tableId = ClientServiceHandler.checkTableId(this.instance, tableName, TableOperation.PERMISSION);
        String namespaceId = Tables.getNamespaceId((Instance)this.instance, (String)tableId);
        security.revokeTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)permission), namespaceId);
    }

    public boolean hasSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte sysPerm) throws ThriftSecurityException {
        return security.hasSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)sysPerm));
    }

    public boolean hasTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte tblPerm) throws ThriftSecurityException, ThriftTableOperationException {
        String tableId = ClientServiceHandler.checkTableId(this.instance, tableName, TableOperation.PERMISSION);
        return security.hasTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)tblPerm));
    }

    public boolean hasNamespacePermission(TInfo tinfo, TCredentials credentials, String user, String ns, byte perm) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId = ClientServiceHandler.checkNamespaceId(this.instance, ns, TableOperation.PERMISSION);
        return security.hasNamespacePermission(credentials, user, namespaceId, NamespacePermission.getPermissionById((byte)perm));
    }

    public void revokeNamespacePermission(TInfo tinfo, TCredentials credentials, String user, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        String namespaceId = ClientServiceHandler.checkNamespaceId(this.instance, ns, TableOperation.PERMISSION);
        security.revokeNamespacePermission(credentials, user, namespaceId, NamespacePermission.getPermissionById((byte)permission));
    }

    public Set<String> listLocalUsers(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        return security.listUsers(credentials);
    }

    private static Map<String, String> conf(TCredentials credentials, AccumuloConfiguration conf) throws TException {
        security.authenticateUser(credentials, credentials);
        conf.invalidateCache();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (Property.isSensitive((String)key)) continue;
            result.put(key, (String)entry.getValue());
        }
        return result;
    }

    public Map<String, String> getConfiguration(TInfo tinfo, TCredentials credentials, ConfigurationType type) throws TException {
        switch (type) {
            case CURRENT: {
                return ClientServiceHandler.conf(credentials, new ServerConfiguration(this.instance).getConfiguration());
            }
            case SITE: {
                return ClientServiceHandler.conf(credentials, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
            }
            case DEFAULT: {
                return ClientServiceHandler.conf(credentials, (AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
            }
        }
        throw new RuntimeException("Unexpected configuration type " + type);
    }

    public Map<String, String> getTableConfiguration(TInfo tinfo, TCredentials credentials, String tableName) throws TException, ThriftTableOperationException {
        String tableId = ClientServiceHandler.checkTableId(this.instance, tableName, null);
        TableConfiguration config = ServerConfiguration.getTableConfiguration(this.instance, tableId);
        return ClientServiceHandler.conf(credentials, (AccumuloConfiguration)config);
    }

    public List<String> bulkImportFiles(TInfo tinfo, final TCredentials credentials, final long tid, final String tableId, final List<String> files, final String errorDir, final boolean setTime) throws ThriftSecurityException, ThriftTableOperationException, TException {
        try {
            if (!security.canPerformSystemActions(credentials)) {
                throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            log.debug((Object)("Got request to bulk import files to table(" + tableId + "): " + files));
            return (List)this.transactionWatcher.run("bulkTx", tid, new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return BulkImporter.bulkLoad(new ServerConfiguration(ClientServiceHandler.this.instance).getConfiguration(), ClientServiceHandler.this.instance, Credentials.fromThrift((TCredentials)credentials), tid, tableId, files, errorDir, setTime);
                }
            });
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (Exception ex) {
            throw new TException((Throwable)ex);
        }
    }

    public boolean isActive(TInfo tinfo, long tid) throws TException {
        return this.transactionWatcher.isActive(tid);
    }

    public boolean checkClass(TInfo tinfo, TCredentials credentials, String className, String interfaceMatch) throws TException {
        security.authenticateUser(credentials, credentials);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            Class test = AccumuloVFSClassLoader.loadClass((String)className, shouldMatch);
            test.newInstance();
            return true;
        }
        catch (ClassCastException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
        catch (InstantiationException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
    }

    public boolean checkTableClass(TInfo tinfo, TCredentials credentials, String tableName, String className, String interfaceMatch) throws TException, ThriftTableOperationException, ThriftSecurityException {
        security.authenticateUser(credentials, credentials);
        String tableId = ClientServiceHandler.checkTableId(this.instance, tableName, null);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            new ServerConfiguration(this.instance).getTableConfiguration(tableId);
            String context = new ServerConfiguration(this.instance).getTableConfiguration(tableId).get(Property.TABLE_CLASSPATH);
            ClassLoader currentLoader = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().getClassLoader(context) : AccumuloVFSClassLoader.getClassLoader();
            Class<?> test = currentLoader.loadClass(className).asSubclass(shouldMatch);
            test.newInstance();
            return true;
        }
        catch (Exception e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
    }

    public boolean checkNamespaceClass(TInfo tinfo, TCredentials credentials, String ns, String className, String interfaceMatch) throws TException, ThriftTableOperationException, ThriftSecurityException {
        security.authenticateUser(credentials, credentials);
        String namespaceId = ClientServiceHandler.checkNamespaceId(this.instance, ns, null);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            new ServerConfiguration(this.instance).getNamespaceConfiguration(namespaceId);
            String context = new ServerConfiguration(this.instance).getNamespaceConfiguration(namespaceId).get(Property.TABLE_CLASSPATH);
            ClassLoader currentLoader = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().getClassLoader(context) : AccumuloVFSClassLoader.getClassLoader();
            Class<?> test = currentLoader.loadClass(className).asSubclass(shouldMatch);
            test.newInstance();
            return true;
        }
        catch (Exception e) {
            log.warn((Object)"Error checking object types", (Throwable)e);
            return false;
        }
    }

    public List<TDiskUsage> getDiskUsage(Set<String> tables, TCredentials credentials) throws ThriftTableOperationException, ThriftSecurityException, TException {
        try {
            Credentials creds = Credentials.fromThrift((TCredentials)credentials);
            Connector conn = this.instance.getConnector(creds.getPrincipal(), creds.getToken());
            HashSet<String> tableIds = new HashSet<String>();
            for (String table : tables) {
                String tableId = ClientServiceHandler.checkTableId(this.instance, table, null);
                tableIds.add(tableId);
                String namespaceId = Tables.getNamespaceId((Instance)this.instance, (String)tableId);
                if (security.canScan(credentials, tableId, namespaceId)) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            Map<TreeSet<String>, Long> diskUsage = TableDiskUsage.getDiskUsage(new ServerConfiguration(this.instance).getConfiguration(), tableIds, this.fs, conn);
            ArrayList<TDiskUsage> retUsages = new ArrayList<TDiskUsage>();
            for (Map.Entry<TreeSet<String>, Long> usageItem : diskUsage.entrySet()) {
                retUsages.add(new TDiskUsage(new ArrayList(usageItem.getKey()), usageItem.getValue().longValue()));
            }
            return retUsages;
        }
        catch (AccumuloSecurityException e) {
            throw e.asThriftException();
        }
        catch (AccumuloException e) {
            throw new TException((Throwable)e);
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
    }

    public Map<String, String> getNamespaceConfiguration(TInfo tinfo, TCredentials credentials, String ns) throws ThriftTableOperationException, TException {
        String namespaceId;
        try {
            namespaceId = Namespaces.getNamespaceId((Instance)this.instance, (String)ns);
        }
        catch (NamespaceNotFoundException e) {
            String why = "Could not find namespace while getting configuration.";
            throw new ThriftTableOperationException(null, ns, null, TableOperationExceptionType.NAMESPACE_NOTFOUND, why);
        }
        NamespaceConfiguration config = ServerConfiguration.getNamespaceConfiguration(this.instance, namespaceId);
        return ClientServiceHandler.conf(credentials, (AccumuloConfiguration)config);
    }
}

