/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.client;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ConnectorImpl;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HdfsZooInstance
implements Instance {
    private static HdfsZooInstance cachedHdfsZooInstance = null;
    private static ZooCache zooCache;
    private static String instanceId;
    private static final Logger log;
    private AccumuloConfiguration conf = null;

    private HdfsZooInstance() {
        SiteConfiguration acuConf = ServerConfiguration.getSiteConfiguration();
        zooCache = new ZooCacheFactory().getZooCache(acuConf.get(Property.INSTANCE_ZK_HOST), (int)acuConf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT));
    }

    public static synchronized Instance getInstance() {
        if (cachedHdfsZooInstance == null) {
            cachedHdfsZooInstance = new HdfsZooInstance();
        }
        return cachedHdfsZooInstance;
    }

    public String getRootTabletLocation() {
        String zRootLocPath = ZooUtil.getRoot((Instance)this) + "/root_tablet/location";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up root tablet location in zoocache.");
        byte[] loc = zooCache.get(zRootLocPath);
        opTimer.stop("Found root tablet at " + (loc == null ? null : new String(loc, Charsets.UTF_8)) + " in %DURATION%");
        if (loc == null) {
            return null;
        }
        return new String(loc, Charsets.UTF_8).split("\\|")[0];
    }

    public List<String> getMasterLocations() {
        String masterLocPath = ZooUtil.getRoot((Instance)this) + "/masters/lock";
        OpTimer opTimer = new OpTimer(log, Level.TRACE).start("Looking up master location in zoocache.");
        byte[] loc = ZooLock.getLockData((ZooCache)zooCache, (String)masterLocPath, null);
        opTimer.stop("Found master at " + (loc == null ? null : new String(loc, Charsets.UTF_8)) + " in %DURATION%");
        if (loc == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new String(loc, Charsets.UTF_8));
    }

    public String getInstanceID() {
        if (instanceId == null) {
            HdfsZooInstance._getInstanceID();
        }
        return instanceId;
    }

    private static synchronized void _getInstanceID() {
        if (instanceId == null) {
            String instanceIdFromFile;
            VolumeManager fs;
            SiteConfiguration acuConf = ServerConfiguration.getSiteConfiguration();
            try {
                fs = VolumeManagerImpl.get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path instanceIdPath = Accumulo.getAccumuloInstanceIdPath(fs);
            log.trace((Object)("Looking for instanceId from " + instanceIdPath));
            instanceId = instanceIdFromFile = ZooUtil.getInstanceIDFromHdfs((Path)instanceIdPath, (AccumuloConfiguration)acuConf);
        }
    }

    public String getInstanceName() {
        return ZooKeeperInstance.lookupInstanceName((ZooCache)zooCache, (UUID)UUID.fromString(this.getInstanceID()));
    }

    public String getZooKeepers() {
        return ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_ZK_HOST);
    }

    public int getZooKeepersSessionTimeOut() {
        return (int)ServerConfiguration.getSiteConfiguration().getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
    }

    public Connector getConnector(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return new ConnectorImpl((Instance)this, new Credentials(principal, token));
    }

    @Deprecated
    public Connector getConnector(String user, byte[] pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, (AuthenticationToken)new PasswordToken(pass));
    }

    @Deprecated
    public Connector getConnector(String user, ByteBuffer pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, ByteBufferUtil.toBytes((ByteBuffer)pass));
    }

    @Deprecated
    public Connector getConnector(String user, CharSequence pass) throws AccumuloException, AccumuloSecurityException {
        return this.getConnector(user, TextUtil.getBytes((Text)new Text(((Object)pass).toString())));
    }

    @Deprecated
    public AccumuloConfiguration getConfiguration() {
        if (this.conf == null) {
            this.conf = new ServerConfiguration(this).getConfiguration();
        }
        return this.conf;
    }

    @Deprecated
    public void setConfiguration(AccumuloConfiguration conf) {
        this.conf = conf;
    }

    public static void main(String[] args) {
        Instance instance = HdfsZooInstance.getInstance();
        System.out.println("Instance Name: " + instance.getInstanceName());
        System.out.println("Instance ID: " + instance.getInstanceID());
        System.out.println("ZooKeepers: " + instance.getZooKeepers());
        System.out.println("Masters: " + StringUtil.join((Collection)instance.getMasterLocations(), (String)", "));
    }

    static {
        instanceId = null;
        log = Logger.getLogger(HdfsZooInstance.class);
    }
}

