/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.security.SecurityPermission;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.ZooConfiguration;

public class ServerConfiguration {
    private static SecurityPermission CONFIGURATION_PERMISSION = new SecurityPermission("configurationPermission");
    private final ServerConfigurationFactory scf;

    public static synchronized SiteConfiguration getSiteConfiguration() {
        ServerConfiguration.checkPermissions();
        return SiteConfiguration.getInstance((AccumuloConfiguration)ServerConfiguration.getDefaultConfiguration());
    }

    private static void checkPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONFIGURATION_PERMISSION);
        }
    }

    private static synchronized ZooConfiguration getZooConfiguration(Instance instance) {
        return (ZooConfiguration)new ServerConfigurationFactory(instance).getConfiguration();
    }

    public static synchronized DefaultConfiguration getDefaultConfiguration() {
        ServerConfiguration.checkPermissions();
        return DefaultConfiguration.getInstance();
    }

    public static synchronized AccumuloConfiguration getSystemConfiguration(Instance instance) {
        return ServerConfiguration.getZooConfiguration(instance);
    }

    public static NamespaceConfiguration getNamespaceConfigurationForTable(Instance instance, String tableId) {
        return new ServerConfigurationFactory(instance).getNamespaceConfigurationForTable(tableId);
    }

    public static NamespaceConfiguration getNamespaceConfiguration(Instance instance, String namespaceId) {
        return new ServerConfigurationFactory(instance).getNamespaceConfiguration(namespaceId);
    }

    public static TableConfiguration getTableConfiguration(Instance instance, String tableId) {
        return new ServerConfigurationFactory(instance).getTableConfiguration(tableId);
    }

    static void expireAllTableObservers() {
        ServerConfigurationFactory.expireAllTableObservers();
    }

    public ServerConfiguration(Instance instance) {
        this.scf = new ServerConfigurationFactory(instance);
    }

    public TableConfiguration getTableConfiguration(String tableId) {
        return this.scf.getTableConfiguration(tableId);
    }

    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return this.getTableConfiguration(extent.getTableId().toString());
    }

    public NamespaceConfiguration getNamespaceConfiguration(String namespaceId) {
        return this.scf.getNamespaceConfiguration(namespaceId);
    }

    public synchronized AccumuloConfiguration getConfiguration() {
        return this.scf.getConfiguration();
    }

    public Instance getInstance() {
        return this.scf.getInstance();
    }
}

