/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class TableConfWatcher
implements Watcher {
    private static final Logger log;
    private final Instance instance;
    private final String tablesPrefix;
    private ServerConfigurationFactory scf;

    TableConfWatcher(Instance instance) {
        this.instance = instance;
        this.tablesPrefix = ZooUtil.getRoot((Instance)instance) + "/tables" + "/";
        this.scf = new ServerConfigurationFactory(instance);
    }

    void setServerConfigurationFactory(ServerConfigurationFactory scf) {
        this.scf = scf;
    }

    static String toString(WatchedEvent event) {
        return "{path=" + event.getPath() + ",state=" + event.getState() + ",type=" + event.getType() + "}";
    }

    public void process(WatchedEvent event) {
        String path = event.getPath();
        if (log.isTraceEnabled()) {
            log.trace((Object)("WatchedEvent : " + TableConfWatcher.toString(event)));
        }
        String tableId = null;
        String key = null;
        if (path != null) {
            if (path.startsWith(this.tablesPrefix) && (tableId = path.substring(this.tablesPrefix.length())).contains("/")) {
                tableId = tableId.substring(0, tableId.indexOf(47));
                if (path.startsWith(this.tablesPrefix + tableId + "/conf" + "/")) {
                    key = path.substring((this.tablesPrefix + tableId + "/conf" + "/").length());
                }
            }
            if (tableId == null) {
                log.warn((Object)("Zookeeper told me about a path I was not watching: " + path + ", event " + TableConfWatcher.toString(event)));
                return;
            }
        }
        block0 : switch (event.getType()) {
            case NodeDataChanged: {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("EventNodeDataChanged " + event.getPath()));
                }
                if (key == null) break;
                this.scf.getTableConfiguration(tableId).propertyChanged(key);
                break;
            }
            case NodeChildrenChanged: {
                this.scf.getTableConfiguration(tableId).propertiesChanged();
                break;
            }
            case NodeDeleted: {
                if (key != null) break;
                ServerConfigurationFactory.removeCachedTableConfiguration(this.instance.getInstanceID(), tableId);
                break;
            }
            case None: {
                switch (event.getState()) {
                    case Expired: {
                        ServerConfigurationFactory.expireAllTableObservers();
                        break block0;
                    }
                    case SyncConnected: {
                        break block0;
                    }
                    case Disconnected: {
                        break block0;
                    }
                }
                log.warn((Object)("EventNone event not handled " + TableConfWatcher.toString(event)));
                break;
            }
            case NodeCreated: {
                switch (event.getState()) {
                    case SyncConnected: {
                        break block0;
                    }
                }
                log.warn((Object)("Event NodeCreated event not handled " + TableConfWatcher.toString(event)));
                break;
            }
            default: {
                log.warn((Object)("Event not handled " + TableConfWatcher.toString(event)));
            }
        }
    }

    static {
        Logger.getLogger((String)"org.apache.zookeeper").setLevel(Level.WARN);
        Logger.getLogger((String)"org.apache.hadoop.io.compress").setLevel(Level.WARN);
        log = Logger.getLogger(TableConfWatcher.class);
    }
}

