/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfWatcher;
import org.apache.accumulo.server.conf.ZooCachePropertyAccessor;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class TableConfiguration
extends ObservableConfiguration {
    private static final Logger log = Logger.getLogger(TableConfiguration.class);
    private static final Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> propCaches = new HashMap<ZooCachePropertyAccessor.PropCacheKey, ZooCache>();
    private ZooCachePropertyAccessor propCacheAccessor = null;
    private final String instanceId;
    private final Instance instance;
    private final NamespaceConfiguration parent;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private String table = null;

    public TableConfiguration(String instanceId, String table, NamespaceConfiguration parent) {
        this(instanceId, HdfsZooInstance.getInstance(), table, parent);
    }

    public TableConfiguration(String instanceId, Instance instance, String table, NamespaceConfiguration parent) {
        this.instanceId = instanceId;
        this.instance = instance;
        this.table = table;
        this.parent = parent;
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ZooCachePropertyAccessor getPropCacheAccessor() {
        if (this.propCacheAccessor == null) {
            Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> map = propCaches;
            synchronized (map) {
                ZooCachePropertyAccessor.PropCacheKey key = new ZooCachePropertyAccessor.PropCacheKey(this.instance.getInstanceID(), this.table);
                ZooCache propCache = propCaches.get(key);
                if (propCache == null) {
                    propCache = this.zcf.getZooCache(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut(), (Watcher)new TableConfWatcher(this.instance));
                    propCaches.put(key, propCache);
                }
                this.propCacheAccessor = new ZooCachePropertyAccessor(propCache);
            }
        }
        return this.propCacheAccessor;
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.table == null) {
            String err = "Attempt to add observer for non-table configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        this.iterator();
        super.addObserver(co);
    }

    public void removeObserver(ConfigurationObserver co) {
        if (this.table == null) {
            String err = "Attempt to remove observer for non-table configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        super.removeObserver(co);
    }

    private String getPath() {
        return ZooUtil.getRoot((String)this.instanceId) + "/tables" + "/" + this.table + "/conf";
    }

    public String get(Property property) {
        return this.getPropCacheAccessor().get(property, this.getPath(), (AccumuloConfiguration)this.parent);
    }

    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        this.getPropCacheAccessor().getProperties(props, this.getPath(), filter, (AccumuloConfiguration)this.parent, null);
    }

    public String getTableId() {
        return this.table;
    }

    public NamespaceConfiguration getNamespaceConfiguration() {
        return new ServerConfigurationFactory(this.parent.inst).getNamespaceConfiguration(this.parent.namespaceId);
    }

    public NamespaceConfiguration getParentConfiguration() {
        return this.parent;
    }

    public synchronized void invalidateCache() {
        if (null != this.propCacheAccessor) {
            this.propCacheAccessor.invalidateCache();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

