/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.base.Charsets;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.log4j.Logger;

public class ZooCachePropertyAccessor {
    private static final Logger log = Logger.getLogger(ZooCachePropertyAccessor.class);
    private final ZooCache propCache;

    ZooCachePropertyAccessor(ZooCache propCache) {
        this.propCache = propCache;
    }

    ZooCache getZooCache() {
        return this.propCache;
    }

    String get(Property property, String path, AccumuloConfiguration parent) {
        String key = property.getKey();
        String value = this.get(path + "/" + key);
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using default value for " + key + " due to improperly formatted " + property.getType() + ": " + value));
            }
            if (parent != null) {
                value = parent.get(property);
            }
        }
        return value;
    }

    private String get(String path) {
        byte[] v = this.propCache.get(path);
        if (v != null) {
            return new String(v, Charsets.UTF_8);
        }
        return null;
    }

    void getProperties(Map<String, String> props, String path, AccumuloConfiguration.PropertyFilter filter, AccumuloConfiguration parent, AccumuloConfiguration.PropertyFilter parentFilter) {
        parent.getProperties(props, parentFilter != null ? parentFilter : filter);
        List children = this.propCache.getChildren(path);
        if (children != null) {
            for (String child : children) {
                String value;
                if (child == null || !filter.accept(child) || (value = this.get(path + "/" + child)) == null) continue;
                props.put(child, value);
            }
        }
    }

    void invalidateCache() {
        this.propCache.clear();
    }

    static class PropCacheKey {
        final String instanceId;
        final String scope;

        PropCacheKey(String iid, String s) {
            this.instanceId = iid;
            this.scope = s;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropCacheKey)) {
                return false;
            }
            PropCacheKey o = (PropCacheKey)other;
            return this.instanceId.equals(o.instanceId) && this.scope.equals(o.scope);
        }

        public int hashCode() {
            int c = 17;
            c = 37 * c + this.instanceId.hashCode();
            c = 37 * c + this.scope.hashCode();
            return c;
        }
    }
}

