/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.base.Charsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.log4j.Logger;

public class ZooConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(ZooConfiguration.class);
    private final String instanceId;
    private final ZooCache propCache;
    private final AccumuloConfiguration parent;
    private final Map<String, String> fixedProps = Collections.synchronizedMap(new HashMap());

    protected ZooConfiguration(String instanceId, ZooCache propCache, AccumuloConfiguration parent) {
        this.instanceId = instanceId;
        this.propCache = propCache;
        this.parent = parent;
    }

    public void invalidateCache() {
        if (this.propCache != null) {
            this.propCache.clear();
        }
    }

    public AccumuloConfiguration getParentConfiguration() {
        return this.parent;
    }

    private String _get(Property property) {
        String key = property.getKey();
        String value = null;
        if (Property.isValidZooPropertyKey((String)key)) {
            value = this.get(key);
        }
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using parent value for " + key + " due to improperly formatted " + property.getType() + ": " + value));
            }
            value = this.parent.get(property);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Property property) {
        if (Property.isFixedZooPropertyKey((Property)property)) {
            if (this.fixedProps.containsKey(property.getKey())) {
                return this.fixedProps.get(property.getKey());
            }
            Map<String, String> map = this.fixedProps;
            synchronized (map) {
                String val = this._get(property);
                this.fixedProps.put(property.getKey(), val);
                return val;
            }
        }
        return this._get(property);
    }

    private String get(String key) {
        String zPath = ZooUtil.getRoot((String)this.instanceId) + "/config" + "/" + key;
        byte[] v = this.propCache.get(zPath);
        String value = null;
        if (v != null) {
            value = new String(v, Charsets.UTF_8);
        }
        return value;
    }

    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        this.parent.getProperties(props, filter);
        List children = this.propCache.getChildren(ZooUtil.getRoot((String)this.instanceId) + "/config");
        if (children != null) {
            for (String child : children) {
                String value;
                if (child == null || !filter.accept(child) || (value = this.get(child)) == null) continue;
                props.put(child, value);
            }
        }
    }
}

