/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class VolumeUtil {
    private static final Logger log = Logger.getLogger(VolumeUtil.class);
    private static final SecureRandom rand = new SecureRandom();

    private static boolean isActiveVolume(Path dir) {
        if (!dir.toString().contains(":")) {
            return true;
        }
        for (String tableDir : ServerConstants.getTablesDirs()) {
            if (!dir.toString().startsWith(new Path(tableDir).toString())) continue;
            return true;
        }
        return false;
    }

    public static String removeTrailingSlash(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static Path removeTrailingSlash(Path path) {
        if (path.toString().endsWith("/")) {
            return new Path(VolumeUtil.removeTrailingSlash(path.toString()));
        }
        return path;
    }

    public static String switchVolume(String path, VolumeManager.FileType ft, List<Pair<Path, Path>> replacements) {
        if (replacements.size() == 0) {
            log.trace((Object)"Not switching volume because there are no replacements");
            return null;
        }
        if (!path.contains(":")) {
            return null;
        }
        Path p = new Path(path);
        Path volume = VolumeUtil.removeTrailingSlash(ft.getVolume(p));
        for (Pair<Path, Path> pair : replacements) {
            Path key = VolumeUtil.removeTrailingSlash((Path)pair.getFirst());
            if (!key.equals((Object)volume)) continue;
            String replacement = new Path((Path)pair.getSecond(), ft.removeVolume(p)).toString();
            log.trace((Object)("Replacing " + path + " with " + replacement));
            return replacement;
        }
        log.trace((Object)("Could not find replacement for " + (Object)((Object)ft) + " at " + path));
        return null;
    }

    private static LogEntry switchVolumes(LogEntry le, List<Pair<Path, Path>> replacements) {
        String switchedPath = VolumeUtil.switchVolume(le.filename, VolumeManager.FileType.WAL, replacements);
        int numSwitched = 0;
        if (switchedPath != null) {
            ++numSwitched;
        } else {
            switchedPath = le.filename;
        }
        ArrayList<String> switchedLogs = new ArrayList<String>();
        for (String log : le.logSet) {
            String switchedLog = VolumeUtil.switchVolume(le.filename, VolumeManager.FileType.WAL, replacements);
            if (switchedLog != null) {
                switchedLogs.add(switchedLog);
                ++numSwitched;
                continue;
            }
            switchedLogs.add(log);
        }
        if (numSwitched == 0) {
            log.trace((Object)("Did not switch " + le));
            return null;
        }
        LogEntry newLogEntry = new LogEntry(le);
        newLogEntry.filename = switchedPath;
        newLogEntry.logSet = switchedLogs;
        log.trace((Object)("Switched " + le + " to " + newLogEntry));
        return newLogEntry;
    }

    public static Text switchRootTabletVolume(KeyExtent extent, Text location) throws IOException {
        String newLocation;
        if (extent.isRootTablet() && (newLocation = VolumeUtil.switchVolume(location.toString(), VolumeManager.FileType.TABLE, ServerConstants.getVolumeReplacements())) != null) {
            MetadataTableUtil.setRootTabletDir(newLocation);
            log.info((Object)("Volume replaced " + extent + " : " + location + " -> " + newLocation));
            return new Text(new Path(newLocation).toString());
        }
        return location;
    }

    public static TabletFiles updateTabletVolumes(ZooLock zooLock, VolumeManager vm, KeyExtent extent, TabletFiles tabletFiles) throws IOException {
        List<Pair<Path, Path>> replacements = ServerConstants.getVolumeReplacements();
        log.trace((Object)("Using volume replacements: " + replacements));
        ArrayList<LogEntry> logsToRemove = new ArrayList<LogEntry>();
        ArrayList<LogEntry> logsToAdd = new ArrayList<LogEntry>();
        ArrayList<FileRef> filesToRemove = new ArrayList<FileRef>();
        TreeMap<FileRef, DataFileValue> filesToAdd = new TreeMap<FileRef, DataFileValue>();
        TabletFiles ret = new TabletFiles();
        for (LogEntry logEntry : tabletFiles.logEntries) {
            LogEntry switchedLogEntry = VolumeUtil.switchVolumes(logEntry, replacements);
            if (switchedLogEntry != null) {
                logsToRemove.add(logEntry);
                logsToAdd.add(switchedLogEntry);
                ret.logEntries.add(switchedLogEntry);
                log.debug((Object)("Replacing volume " + extent + " : " + logEntry.filename + " -> " + switchedLogEntry.filename));
                continue;
            }
            ret.logEntries.add(logEntry);
        }
        if (extent.isRootTablet()) {
            ret.datafiles = tabletFiles.datafiles;
        } else {
            for (Map.Entry entry : tabletFiles.datafiles.entrySet()) {
                String metaPath = ((FileRef)entry.getKey()).meta().toString();
                String switchedPath = VolumeUtil.switchVolume(metaPath, VolumeManager.FileType.TABLE, replacements);
                if (switchedPath != null) {
                    filesToRemove.add((FileRef)entry.getKey());
                    FileRef switchedRef = new FileRef(switchedPath, new Path(switchedPath));
                    filesToAdd.put(switchedRef, (DataFileValue)entry.getValue());
                    ret.datafiles.put(switchedRef, (DataFileValue)entry.getValue());
                    log.debug((Object)("Replacing volume " + extent + " : " + metaPath + " -> " + switchedPath));
                    continue;
                }
                ret.datafiles.put((FileRef)entry.getKey(), (DataFileValue)entry.getValue());
            }
        }
        String tabletDir = tabletFiles.dir;
        String string = VolumeUtil.switchVolume(tabletDir, VolumeManager.FileType.TABLE, replacements);
        if (string != null) {
            log.debug((Object)("Replacing volume " + extent + " : " + tabletDir + " -> " + string));
            tabletDir = string;
        }
        if (logsToRemove.size() + filesToRemove.size() > 0 || string != null) {
            MetadataTableUtil.updateTabletVolumes(extent, logsToRemove, logsToAdd, filesToRemove, filesToAdd, string, zooLock, SystemCredentials.get());
        }
        ret.dir = VolumeUtil.decommisionedTabletDir(zooLock, vm, extent, tabletDir);
        return ret;
    }

    private static String decommisionedTabletDir(ZooLock zooLock, VolumeManager vm, KeyExtent extent, String metaDir) throws IOException {
        Path dir = new Path(metaDir);
        if (VolumeUtil.isActiveVolume(dir)) {
            return metaDir;
        }
        if (!dir.getParent().getParent().getName().equals("tables")) {
            throw new IllegalArgumentException("Unexpected table dir " + dir);
        }
        Path newDir = new Path(vm.choose(ServerConstants.getBaseUris()) + "/" + "tables" + "/" + dir.getParent().getName() + "/" + dir.getName());
        log.info((Object)("Updating directory for " + extent + " from " + dir + " to " + newDir));
        if (extent.isRootTablet()) {
            FileSystem fs2;
            FileSystem fs1 = vm.getVolumeByPath(dir).getFileSystem();
            if (!VolumeUtil.same(fs1, dir, fs2 = vm.getVolumeByPath(newDir).getFileSystem(), newDir)) {
                if (fs2.exists(newDir)) {
                    Path newDirBackup = VolumeUtil.getBackupName(fs2, newDir);
                    log.info((Object)("renaming " + newDir + " to " + newDirBackup));
                    if (!fs2.rename(newDir, newDirBackup)) {
                        throw new IOException("Failed to rename " + newDir + " to " + newDirBackup);
                    }
                }
                log.info((Object)("copying " + dir + " to " + newDir));
                if (!FileUtil.copy((FileSystem)fs1, (Path)dir, (FileSystem)fs2, (Path)newDir, (boolean)false, (Configuration)CachedConfiguration.getInstance())) {
                    throw new IOException("Failed to copy " + dir + " to " + newDir);
                }
                log.info((Object)("setting root tablet location to " + newDir));
                MetadataTableUtil.setRootTabletDir(newDir.toString());
                Path dirBackup = VolumeUtil.getBackupName(fs1, dir);
                log.info((Object)("renaming " + dir + " to " + dirBackup));
                fs1.rename(dir, dirBackup);
            } else {
                log.info((Object)("setting root tablet location to " + newDir));
                MetadataTableUtil.setRootTabletDir(newDir.toString());
            }
            return newDir.toString();
        }
        MetadataTableUtil.updateTabletDir(extent, newDir.toString(), SystemCredentials.get(), zooLock);
        return newDir.toString();
    }

    static boolean same(FileSystem fs1, Path dir, FileSystem fs2, Path newDir) throws FileNotFoundException, IOException {
        if (fs1.exists(dir) && fs2.exists(newDir)) {
            HashSet<String> names2;
            if (!fs1.isDirectory(dir)) {
                throw new IllegalArgumentException("expected " + dir + " to be a directory");
            }
            if (!fs2.isDirectory(newDir)) {
                throw new IllegalArgumentException("expected " + newDir + " to be a directory");
            }
            HashSet<String> names1 = VolumeUtil.getFileNames(fs1.listStatus(dir));
            if (names1.equals(names2 = VolumeUtil.getFileNames(fs2.listStatus(newDir)))) {
                for (String name : names1) {
                    if (VolumeUtil.hash(fs1, dir, name).equals(VolumeUtil.hash(fs2, newDir, name))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static HashSet<String> getFileNames(FileStatus[] filesStatuses) {
        HashSet<String> names = new HashSet<String>();
        for (FileStatus fileStatus : filesStatuses) {
            if (fileStatus.isDir()) {
                throw new IllegalArgumentException("expected " + fileStatus.getPath() + " to be a file");
            }
            names.add(fileStatus.getPath().getName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hash(FileSystem fs, Path dir, String name) throws IOException {
        FSDataInputStream in = fs.open(new Path(dir, name));
        try {
            String string = DigestUtils.shaHex((InputStream)in);
            return string;
        }
        finally {
            in.close();
        }
    }

    private static Path getBackupName(FileSystem fs, Path path) {
        return new Path(path.getParent(), path.getName() + "_" + System.currentTimeMillis() + "_" + (rand.nextInt(Integer.MAX_VALUE) + 1) + ".bak");
    }

    public static class TabletFiles {
        public String dir;
        public List<LogEntry> logEntries;
        public SortedMap<FileRef, DataFileValue> datafiles;

        public TabletFiles() {
            this.logEntries = new ArrayList<LogEntry>();
            this.datafiles = new TreeMap<FileRef, DataFileValue>();
        }

        public TabletFiles(String dir, List<LogEntry> logEntries, SortedMap<FileRef, DataFileValue> datafiles) {
            this.dir = dir;
            this.logEntries = logEntries;
            this.datafiles = datafiles;
        }
    }
}

