/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.transport.TTransportException;

public abstract class TabletBalancer {
    private static final Logger log = Logger.getLogger(TabletBalancer.class);
    protected ServerConfiguration configuration;
    private static final long ONE_SECOND = 1000L;
    private boolean stuck = false;
    private long stuckNotificationTime = -1L;
    protected static final long TIME_BETWEEN_BALANCER_WARNINGS = 60000L;

    public void init(ServerConfiguration conf) {
        this.configuration = conf;
    }

    public abstract void getAssignments(SortedMap<TServerInstance, TabletServerStatus> var1, Map<KeyExtent, TServerInstance> var2, Map<KeyExtent, TServerInstance> var3);

    public abstract long balance(SortedMap<TServerInstance, TabletServerStatus> var1, Set<KeyExtent> var2, List<TabletMigration> var3);

    protected void constraintNotMet(BalancerProblem cause) {
        if (!this.stuck) {
            this.stuck = true;
            this.stuckNotificationTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.stuckNotificationTime > 60000L) {
            cause.run();
            this.stuckNotificationTime = System.currentTimeMillis();
        }
    }

    protected void resetBalancerErrors() {
        this.stuck = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TabletStats> getOnlineTabletsForTable(TServerInstance tserver, String tableId) throws ThriftSecurityException, TException {
        log.debug((Object)("Scanning tablet server " + tserver + " for table " + tableId));
        TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (HostAndPort)tserver.getLocation(), (AccumuloConfiguration)this.configuration.getConfiguration());
        try {
            List onlineTabletsForTable;
            List list = onlineTabletsForTable = client.getTabletStats(Tracer.traceInfo(), SystemCredentials.get().toThrift(this.configuration.getInstance()), tableId);
            return list;
        }
        catch (TTransportException e) {
            log.error((Object)("Unable to connect to " + tserver + ": " + (Object)((Object)e)));
        }
        finally {
            ThriftUtil.returnClient((TServiceClient)client);
        }
        return null;
    }

    public static List<TabletMigration> checkMigrationSanity(Set<TServerInstance> current, List<TabletMigration> migrations) {
        ArrayList<TabletMigration> result = new ArrayList<TabletMigration>(migrations.size());
        for (TabletMigration m : migrations) {
            if (m.tablet == null) {
                log.warn((Object)("Balancer gave back a null tablet " + m));
                continue;
            }
            if (m.newServer == null) {
                log.warn((Object)("Balancer did not set the destination " + m));
                continue;
            }
            if (m.oldServer == null) {
                log.warn((Object)("Balancer did not set the source " + m));
                continue;
            }
            if (!current.contains(m.oldServer)) {
                log.warn((Object)("Balancer wants to move a tablet from a server that is not current: " + m));
                continue;
            }
            if (!current.contains(m.newServer)) {
                log.warn((Object)("Balancer wants to move a tablet to a server that is not current: " + m));
                continue;
            }
            result.add(m);
        }
        return result;
    }

    protected static class OutstandingMigrations
    extends BalancerProblem {
        public Set<KeyExtent> migrations = Collections.emptySet();

        public OutstandingMigrations(Logger logger) {
            super(logger);
        }

        @Override
        public void run() {
            this.balancerLog.warn((Object)("Not balancing due to " + this.migrations.size() + " outstanding migrations."));
            this.balancerLog.debug((Object)("Sample up to 10 outstanding migrations: " + Iterables.limit(this.migrations, (int)10)));
        }
    }

    protected static class NoTservers
    extends BalancerProblem {
        public NoTservers(Logger logger) {
            super(logger);
        }

        @Override
        public void run() {
            this.balancerLog.warn((Object)"Not balancing because we don't have any tservers");
        }
    }

    protected static abstract class BalancerProblem
    implements Runnable {
        protected final Logger balancerLog;

        public BalancerProblem(Logger logger) {
            this.balancerLog = logger;
        }
    }
}

