/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.recovery;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.server.fs.ViewFSUtils;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.recovery.LogCloser;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.log4j.Logger;

public class HadoopLogCloser
implements LogCloser {
    private static Logger log = Logger.getLogger(HadoopLogCloser.class);

    @Override
    public long close(AccumuloConfiguration conf, VolumeManager fs, Path source) throws IOException {
        Path newSource;
        FileSystem ns = fs.getVolumeByPath(source).getFileSystem();
        if (ViewFSUtils.isViewFS(ns) && !(newSource = ViewFSUtils.resolvePath(ns, source)).equals((Object)source) && newSource.toUri().getScheme() != null) {
            ns = newSource.getFileSystem(CachedConfiguration.getInstance());
            source = newSource;
        }
        if (ns instanceof DistributedFileSystem) {
            DistributedFileSystem dfs = (DistributedFileSystem)ns;
            try {
                if (!dfs.recoverLease(source)) {
                    log.info((Object)("Waiting for file to be closed " + source.toString()));
                    return conf.getTimeInMillis(Property.MASTER_LEASE_RECOVERY_WAITING_PERIOD);
                }
                log.info((Object)("Recovered lease on " + source.toString()));
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.warn((Object)("Error recovering lease on " + source.toString()), (Throwable)ex);
                ns.append(source).close();
                log.info((Object)("Recovered lease on " + source.toString() + " using append"));
            }
        } else if (!(ns instanceof LocalFileSystem) && !(ns instanceof RawLocalFileSystem)) {
            throw new IllegalStateException("Don't know how to recover a lease for " + ns.getClass().getName());
        }
        return 0L;
    }
}

