/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.hadoop.io.Text;

public class TabletLocationState {
    public final KeyExtent extent;
    public final TServerInstance future;
    public final TServerInstance current;
    public final TServerInstance last;
    public final Collection<Collection<String>> walogs;
    public final boolean chopped;

    public TabletLocationState(KeyExtent extent, TServerInstance future, TServerInstance current, TServerInstance last, Collection<Collection<String>> walogs, boolean chopped) throws BadLocationStateException {
        this.extent = extent;
        this.future = future;
        this.current = current;
        this.last = last;
        if (walogs == null) {
            walogs = Collections.emptyList();
        }
        this.walogs = walogs;
        this.chopped = chopped;
        if (current != null && future != null) {
            throw new BadLocationStateException(extent + " is both assigned and hosted, which should never happen: " + this, extent.getMetadataEntry());
        }
    }

    public String toString() {
        return this.extent + "@(" + this.future + "," + this.current + "," + this.last + ")" + (this.chopped ? " chopped" : "");
    }

    public TServerInstance getServer() {
        TServerInstance result = null;
        result = this.current != null ? this.current : (this.future != null ? this.future : this.last);
        return result;
    }

    public TabletState getState(Set<TServerInstance> liveServers) {
        TServerInstance server = this.getServer();
        if (server == null) {
            return TabletState.UNASSIGNED;
        }
        if (server.equals(this.current) || server.equals(this.future)) {
            if (liveServers.contains(server)) {
                if (server.equals(this.future)) {
                    return TabletState.ASSIGNED;
                }
                return TabletState.HOSTED;
            }
            return TabletState.ASSIGNED_TO_DEAD_SERVER;
        }
        return TabletState.UNASSIGNED;
    }

    public static class BadLocationStateException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Text metadataTableEntry;

        BadLocationStateException(String msg, Text row) {
            super(msg);
            this.metadataTableEntry = row;
        }

        public Text getEncodedEndRow() {
            return this.metadataTableEntry;
        }
    }
}

