/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class CompactionIterators
implements Writable {
    byte[] startRow;
    byte[] endRow;
    List<IteratorSetting> iterators;

    public CompactionIterators(byte[] startRow, byte[] endRow, List<IteratorSetting> iterators) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.iterators = iterators;
    }

    public CompactionIterators() {
        this.startRow = null;
        this.endRow = null;
        this.iterators = Collections.emptyList();
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.startRow != null);
        if (this.startRow != null) {
            out.writeInt(this.startRow.length);
            out.write(this.startRow);
        }
        out.writeBoolean(this.endRow != null);
        if (this.endRow != null) {
            out.writeInt(this.endRow.length);
            out.write(this.endRow);
        }
        out.writeInt(this.iterators.size());
        for (IteratorSetting is : this.iterators) {
            is.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.startRow = new byte[in.readInt()];
            in.readFully(this.startRow);
        } else {
            this.startRow = null;
        }
        if (in.readBoolean()) {
            this.endRow = new byte[in.readInt()];
            in.readFully(this.endRow);
        } else {
            this.endRow = null;
        }
        int num = in.readInt();
        this.iterators = new ArrayList<IteratorSetting>(num);
        for (int i = 0; i < num; ++i) {
            this.iterators.add(new IteratorSetting(in));
        }
    }

    public Text getEndRow() {
        if (this.endRow == null) {
            return null;
        }
        return new Text(this.endRow);
    }

    public Text getStartRow() {
        if (this.startRow == null) {
            return null;
        }
        return new Text(this.startRow);
    }

    public List<IteratorSetting> getIterators() {
        return this.iterators;
    }
}

