/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.accumulo.server.metrics.MetricsConfiguration;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public abstract class AbstractMetricsImpl {
    static final Logger log = Logger.getLogger(AbstractMetricsImpl.class);
    private static ConcurrentHashMap<String, Metric> registry = new ConcurrentHashMap();
    private boolean currentlyLogging = false;
    private File logDir = null;
    private String metricsPrefix = null;
    private Date today = new Date();
    private File logFile = null;
    private Writer logWriter = null;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
    private SimpleDateFormat logFormatter = new SimpleDateFormat("yyyyMMddhhmmssz");
    private MetricsConfiguration config = null;

    public AbstractMetricsImpl() {
        this.metricsPrefix = this.getMetricsPrefix();
        this.config = new MetricsConfiguration(this.metricsPrefix);
    }

    public void register(StandardMBean mbean) throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (null == this.getObjectName()) {
            throw new IllegalArgumentException("MBean object name must be set.");
        }
        mbs.registerMBean(mbean, this.getObjectName());
        this.setupLogging();
    }

    public void register() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (null == this.getObjectName()) {
            throw new IllegalArgumentException("MBean object name must be set.");
        }
        mbs.registerMBean(this, this.getObjectName());
        this.setupLogging();
    }

    public void createMetric(String name) {
        registry.put(name, new Metric());
    }

    public Metric getMetric(String name) {
        return registry.get(name);
    }

    public long getMetricCount(String name) {
        return registry.get(name).getCount();
    }

    public long getMetricAvg(String name) {
        return registry.get(name).getAvg();
    }

    public long getMetricMin(String name) {
        return registry.get(name).getMin();
    }

    public long getMetricMax(String name) {
        return registry.get(name).getMax();
    }

    private void setupLogging() throws IOException {
        if (null == this.config.getMetricsConfiguration()) {
            return;
        }
        if (!this.currentlyLogging && this.config.getMetricsConfiguration().getBoolean(this.metricsPrefix + ".logging", false)) {
            String mDir = this.config.getMetricsConfiguration().getString("logging.dir");
            if (null != mDir) {
                File dir = new File(mDir);
                if (!dir.isDirectory() && !dir.mkdir()) {
                    log.warn((Object)("Could not create log directory: " + dir));
                }
                this.logDir = dir;
                this.startNewLog();
            }
            this.currentlyLogging = true;
        }
    }

    private void startNewLog() throws IOException {
        if (null != this.logWriter) {
            this.logWriter.flush();
            this.logWriter.close();
        }
        this.logFile = new File(this.logDir, this.metricsPrefix + "-" + this.formatter.format(this.today) + ".log");
        if (!this.logFile.exists() && !this.logFile.createNewFile()) {
            log.error((Object)"Unable to create new log file");
            this.currentlyLogging = false;
            return;
        }
        this.logWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile, true), Charsets.UTF_8);
    }

    private void writeToLog(String name) throws IOException {
        if (null == this.logWriter) {
            return;
        }
        Date now = new Date();
        if (!DateUtils.isSameDay((Date)this.today, (Date)now)) {
            this.today = now;
            this.startNewLog();
        }
        this.logWriter.append(this.logFormatter.format(now)).append(" Metric: ").append(name).append(": ").append(registry.get(name).toString()).append("\n");
    }

    public void add(String name, long time) {
        if (this.isEnabled()) {
            registry.get(name).incCount();
            registry.get(name).addAvg(time);
            registry.get(name).addMin(time);
            registry.get(name).addMax(time);
            if (!this.currentlyLogging && this.config.getMetricsConfiguration().getBoolean(this.metricsPrefix + ".logging", false)) {
                try {
                    this.setupLogging();
                }
                catch (IOException ioe) {
                    log.error((Object)"Error setting up log", (Throwable)ioe);
                }
            } else if (this.currentlyLogging && !this.config.getMetricsConfiguration().getBoolean(this.metricsPrefix + ".logging", false)) {
                try {
                    this.logWriter.flush();
                    this.logWriter.close();
                    this.logWriter = null;
                    this.logFile = null;
                }
                catch (Exception e) {
                    log.error((Object)"Error stopping metrics logging", (Throwable)e);
                }
                this.currentlyLogging = false;
            }
            if (this.currentlyLogging) {
                try {
                    this.writeToLog(name);
                }
                catch (IOException ioe) {
                    log.error((Object)"Error writing to metrics log", (Throwable)ioe);
                }
            }
        }
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    protected abstract ObjectName getObjectName();

    protected abstract String getMetricsPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        if (null != this.logWriter) {
            try {
                this.logWriter.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.logWriter = null;
            }
        }
        this.logFile = null;
    }

    public class Metric {
        private long count = 0L;
        private long avg = 0L;
        private long min = 0L;
        private long max = 0L;

        public long getCount() {
            return this.count;
        }

        public long getAvg() {
            return this.avg;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public void incCount() {
            ++this.count;
        }

        public void addAvg(long a) {
            if (a < 0L) {
                return;
            }
            this.avg = (long)((double)this.avg * 0.8 + (double)a * 0.2);
        }

        public void addMin(long a) {
            if (a < 0L) {
                return;
            }
            this.min = Math.min(this.min, a);
        }

        public void addMax(long a) {
            if (a < 0L) {
                return;
            }
            this.max = Math.max(this.max, a);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("count", this.count).append("average", this.avg).append("minimum", this.min).append("maximum", this.max).toString();
        }
    }
}

