/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.problems;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.LoggingRunnable;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class ProblemReports
implements Iterable<ProblemReport> {
    private static final Logger log = Logger.getLogger(ProblemReports.class);
    private final LRUMap problemReports = new LRUMap(1000);
    private ExecutorService reportExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(500), (ThreadFactory)new NamingThreadFactory("acu-problem-reporter"));
    private static ProblemReports instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(final ProblemReport pr) {
        LRUMap lRUMap = this.problemReports;
        synchronized (lRUMap) {
            if (this.problemReports.containsKey((Object)pr)) {
                return;
            }
            this.problemReports.put((Object)pr, (Object)System.currentTimeMillis());
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                log.debug((Object)("Filing problem report " + pr.getTableName() + " " + (Object)((Object)pr.getProblemType()) + " " + pr.getResource()));
                try {
                    if (ProblemReports.isMeta(pr.getTableName())) {
                        pr.saveToZooKeeper();
                    } else {
                        pr.saveToMetadataTable();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed to file problem report " + pr.getTableName() + " " + (Object)((Object)pr.getProblemType()) + " " + pr.getResource()), (Throwable)e);
                }
            }
        };
        try {
            this.reportExecutor.execute((Runnable)new LoggingRunnable(log, r));
        }
        catch (RejectedExecutionException ree) {
            log.error((Object)("Failed to report problem " + pr.getTableName() + " " + (Object)((Object)pr.getProblemType()) + " " + pr.getResource() + "  " + ree.getMessage()));
        }
    }

    public void printProblems() throws Exception {
        for (ProblemReport pr : this) {
            System.out.println(pr.getTableName() + " " + (Object)((Object)pr.getProblemType()) + " " + pr.getResource() + " " + pr.getException());
        }
    }

    public void deleteProblemReport(String table, ProblemType pType, String resource) {
        final ProblemReport pr = new ProblemReport(table, pType, resource, null);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ProblemReports.isMeta(pr.getTableName())) {
                        pr.removeFromZooKeeper();
                    } else {
                        pr.removeFromMetadataTable();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Failed to delete problem report " + pr.getTableName() + " " + (Object)((Object)pr.getProblemType()) + " " + pr.getResource()), (Throwable)e);
                }
            }
        };
        try {
            this.reportExecutor.execute((Runnable)new LoggingRunnable(log, r));
        }
        catch (RejectedExecutionException ree) {
            log.error((Object)("Failed to delete problem report " + pr.getTableName() + " " + (Object)((Object)pr.getProblemType()) + " " + pr.getResource() + "  " + ree.getMessage()));
        }
    }

    public void deleteProblemReports(String table) throws Exception {
        if (ProblemReports.isMeta(table)) {
            Iterator<ProblemReport> pri = this.iterator(table);
            while (pri.hasNext()) {
                pri.next().removeFromZooKeeper();
            }
            return;
        }
        Connector connector = HdfsZooInstance.getInstance().getConnector(SystemCredentials.get().getPrincipal(), SystemCredentials.get().getToken());
        Scanner scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        scanner.addScanIterator(new IteratorSetting(1, "keys-only", SortedKeyIterator.class));
        scanner.setRange(new Range(new Text("~err_" + table)));
        Mutation delMut = new Mutation(new Text("~err_" + table));
        boolean hasProblems = false;
        for (Map.Entry entry : scanner) {
            hasProblems = true;
            delMut.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
        }
        if (hasProblems) {
            MetadataTableUtil.getMetadataTable(SystemCredentials.get()).update(delMut);
        }
    }

    private static boolean isMeta(String tableId) {
        return tableId.equals("!0") || tableId.equals("+r");
    }

    public Iterator<ProblemReport> iterator(final String table) {
        try {
            return new Iterator<ProblemReport>(){
                IZooReaderWriter zoo = ZooReaderWriter.getInstance();
                private int iter1Count = 0;
                private Iterator<String> iter1;
                private Iterator<Map.Entry<Key, Value>> iter2;

                private Iterator<String> getIter1() {
                    if (this.iter1 == null) {
                        try {
                            List children = table == null || ProblemReports.isMeta(table) ? this.zoo.getChildren(ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/problems") : Collections.emptyList();
                            this.iter1 = children.iterator();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.iter1;
                }

                private Iterator<Map.Entry<Key, Value>> getIter2() {
                    if (this.iter2 == null) {
                        try {
                            if (!(table != null && ProblemReports.isMeta(table) || this.iter1Count != 0)) {
                                Connector connector = HdfsZooInstance.getInstance().getConnector(SystemCredentials.get().getPrincipal(), SystemCredentials.get().getToken());
                                Scanner scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
                                scanner.setTimeout(3L, TimeUnit.SECONDS);
                                if (table == null) {
                                    scanner.setRange(new Range(new Text("~err_"), false, new Text("~err`"), false));
                                } else {
                                    scanner.setRange(new Range(new Text("~err_" + table)));
                                }
                                this.iter2 = scanner.iterator();
                            } else {
                                Map m = Collections.emptyMap();
                                this.iter2 = m.entrySet().iterator();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.iter2;
                }

                @Override
                public boolean hasNext() {
                    if (this.getIter1().hasNext()) {
                        return true;
                    }
                    return this.getIter2().hasNext();
                }

                @Override
                public ProblemReport next() {
                    try {
                        if (this.getIter1().hasNext()) {
                            ++this.iter1Count;
                            return ProblemReport.decodeZooKeeperEntry(this.getIter1().next());
                        }
                        if (this.getIter2().hasNext()) {
                            return ProblemReport.decodeMetadataEntry(this.getIter2().next());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<ProblemReport> iterator() {
        return this.iterator(null);
    }

    public static synchronized ProblemReports getInstance() {
        if (instance == null) {
            instance = new ProblemReports();
        }
        return instance;
    }

    public static void main(String[] args) throws Exception {
        ProblemReports.getInstance().printProblems();
    }

    public Map<String, Map<ProblemType, Integer>> summarize() {
        TreeMap<String, Map<ProblemType, Integer>> summary = new TreeMap<String, Map<ProblemType, Integer>>();
        for (ProblemReport pr : this) {
            Integer count;
            Map<ProblemType, Integer> tableProblems = summary.get(pr.getTableName());
            if (tableProblems == null) {
                tableProblems = new EnumMap<ProblemType, Integer>(ProblemType.class);
                summary.put(pr.getTableName(), tableProblems);
            }
            if ((count = tableProblems.get((Object)pr.getProblemType())) == null) {
                count = 0;
            }
            tableProblems.put(pr.getProblemType(), count + 1);
        }
        return summary;
    }
}

