/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class SecurityUtil {
    private static final Logger log = Logger.getLogger(SecurityUtil.class);
    private static final Logger renewalLog = Logger.getLogger((String)"KerberosTicketRenewal");
    public static boolean usingKerberos = false;

    public static void serverLogin(AccumuloConfiguration acuConf) {
        String keyTab = acuConf.getPath(Property.GENERAL_KERBEROS_KEYTAB);
        if (keyTab == null || keyTab.length() == 0) {
            return;
        }
        usingKerberos = true;
        String principalConfig = acuConf.get(Property.GENERAL_KERBEROS_PRINCIPAL);
        if (principalConfig == null || principalConfig.length() == 0) {
            return;
        }
        if (SecurityUtil.login(principalConfig, keyTab)) {
            try {
                SecurityUtil.startTicketRenewalThread(UserGroupInformation.getCurrentUser(), acuConf.getTimeInMillis(Property.GENERAL_KERBEROS_RENEWAL_PERIOD));
                return;
            }
            catch (IOException e) {
                log.error((Object)"Failed to obtain Kerberos user after successfully logging in", (Throwable)e);
            }
        }
        throw new RuntimeException("Failed to perform Kerberos login for " + principalConfig + " using  " + keyTab);
    }

    public static boolean login(String principalConfig, String keyTabPath) {
        try {
            String principalName = org.apache.hadoop.security.SecurityUtil.getServerPrincipal((String)principalConfig, (String)InetAddress.getLocalHost().getCanonicalHostName());
            if (keyTabPath != null && principalName != null && keyTabPath.length() != 0 && principalName.length() != 0) {
                UserGroupInformation.loginUserFromKeytab((String)principalName, (String)keyTabPath);
                log.info((Object)("Succesfully logged in as user " + principalConfig));
                return true;
            }
        }
        catch (IOException io) {
            log.error((Object)("Error logging in user " + principalConfig + " using keytab at " + keyTabPath), (Throwable)io);
        }
        return false;
    }

    static void startTicketRenewalThread(final UserGroupInformation ugi, final long renewalPeriod) {
        Daemon t = new Daemon((Runnable)new LoggingRunnable(renewalLog, new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        renewalLog.debug((Object)"Invoking renewal attempt for Kerberos ticket");
                        ugi.checkTGTAndReloginFromKeytab();
                    }
                    catch (IOException e) {
                        renewalLog.error((Object)"Failed to renew Kerberos ticket", (Throwable)e);
                    }
                    try {
                        Thread.sleep(renewalPeriod);
                    }
                    catch (InterruptedException e) {
                        renewalLog.error((Object)"Renewal thread interrupted", (Throwable)e);
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }));
        t.setName("Kerberos Ticket Renewal");
        t.start();
    }
}

