/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.zookeeper.KeeperException;

public class AccumuloStatus {
    public static boolean isAccumuloOffline(IZooReader reader) throws IOException {
        String rootPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance());
        return AccumuloStatus.isAccumuloOffline(reader, rootPath);
    }

    public static boolean isAccumuloOffline(IZooReader reader, String rootPath) throws IOException {
        try {
            for (String child : reader.getChildren(rootPath + "/tservers")) {
                if (reader.getChildren(rootPath + "/tservers" + "/" + child).isEmpty()) continue;
                return false;
            }
            if (!reader.getChildren(rootPath + "/tracers").isEmpty()) {
                return false;
            }
            if (!reader.getChildren(rootPath + "/masters/lock").isEmpty()) {
                return false;
            }
            if (!reader.getChildren(rootPath + "/monitor/lock").isEmpty()) {
                return false;
            }
            if (!reader.getChildren(rootPath + "/gc/lock").isEmpty()) {
                return false;
            }
        }
        catch (KeeperException e) {
            throw new IOException("Issues contacting ZooKeeper to get Accumulo status.", e);
        }
        catch (InterruptedException e) {
            throw new IOException("Issues contacting ZooKeeper to get Accumulo status.", e);
        }
        return true;
    }
}

