/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.util.FindOfflineTablets;
import org.apache.accumulo.server.util.ListInstances;
import org.apache.accumulo.server.util.ListVolumesUsed;
import org.apache.accumulo.server.util.RandomizeVolumes;
import org.apache.accumulo.server.util.RemoveEntriesForMissingFiles;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class Admin {
    private static final Logger log = Logger.getLogger(Admin.class);
    private static final String ACCUMULO_SITE_BACKUP_FILE = "accumulo-site.xml.bak";
    private static final String NS_FILE_SUFFIX = "_ns.cfg";
    private static final String USER_FILE_SUFFIX = "_user.cfg";
    private static final MessageFormat configFormat = new MessageFormat("config -t {0} -s {1}\n");
    private static final MessageFormat createNsFormat = new MessageFormat("createnamespace {0}\n");
    private static final MessageFormat createTableFormat = new MessageFormat("createtable {0}\n");
    private static final MessageFormat createUserFormat = new MessageFormat("createuser {0}\n");
    private static final MessageFormat nsConfigFormat = new MessageFormat("config -ns {0} -s {1}\n");
    private static final MessageFormat sysPermFormat = new MessageFormat("grant System.{0} -s -u {1}\n");
    private static final MessageFormat nsPermFormat = new MessageFormat("grant Namespace.{0} -ns {1} -u {2}\n");
    private static final MessageFormat tablePermFormat = new MessageFormat("grant Table.{0} -t {1} -u {2}\n");
    private static final MessageFormat userAuthsFormat = new MessageFormat("setauths -u {0} -s {1}\n");
    private static DefaultConfiguration defaultConfig;
    private static Map<String, String> siteConfig;
    private static Map<String, String> systemConfig;
    private static List<String> localUsers;

    public static void main(String[] args) {
        AdminOpts opts = new AdminOpts();
        JCommander cl = new JCommander((Object)opts);
        cl.setProgramName(Admin.class.getName());
        CheckTabletsCommand checkTabletsCommand = new CheckTabletsCommand();
        cl.addCommand("checkTablets", (Object)checkTabletsCommand);
        ListInstancesCommand listIntancesOpts = new ListInstancesCommand();
        cl.addCommand("listInstances", (Object)listIntancesOpts);
        PingCommand pingCommand = new PingCommand();
        cl.addCommand("ping", (Object)pingCommand);
        DumpConfigCommand dumpConfigCommand = new DumpConfigCommand();
        cl.addCommand("dumpConfig", (Object)dumpConfigCommand);
        VolumesCommand volumesCommand = new VolumesCommand();
        cl.addCommand("volumes", (Object)volumesCommand);
        StopCommand stopOpts = new StopCommand();
        cl.addCommand("stop", (Object)stopOpts);
        StopAllCommand stopAllOpts = new StopAllCommand();
        cl.addCommand("stopAll", (Object)stopAllOpts);
        StopMasterCommand stopMasterOpts = new StopMasterCommand();
        cl.addCommand("stopMaster", (Object)stopMasterOpts);
        RandomizeVolumesCommand randomizeVolumesOpts = new RandomizeVolumesCommand();
        cl.addCommand("randomizeVolumes", (Object)randomizeVolumesOpts);
        cl.parse(args);
        if (opts.help || cl.getParsedCommand() == null) {
            cl.usage();
            return;
        }
        Instance instance = opts.getInstance();
        try {
            AuthenticationToken token;
            String principal;
            if (opts.getToken() == null) {
                principal = SystemCredentials.get().getPrincipal();
                token = SystemCredentials.get().getToken();
            } else {
                principal = opts.principal;
                token = opts.getToken();
            }
            int rc = 0;
            if (cl.getParsedCommand().equals("listInstances")) {
                ListInstances.listInstances(instance.getZooKeepers(), listIntancesOpts.printAll, listIntancesOpts.printErrors);
            } else if (cl.getParsedCommand().equals("ping")) {
                if (Admin.ping(instance, principal, token, pingCommand.args) != 0) {
                    rc = 4;
                }
            } else if (cl.getParsedCommand().equals("checkTablets")) {
                System.out.println("\n*** Looking for offline tablets ***\n");
                if (FindOfflineTablets.findOffline(instance, new Credentials(principal, token), checkTabletsCommand.table) != 0) {
                    rc = 5;
                }
                System.out.println("\n*** Looking for missing files ***\n");
                if (checkTabletsCommand.table == null) {
                    if (RemoveEntriesForMissingFiles.checkAllTables(instance, principal, token, checkTabletsCommand.fixFiles) != 0) {
                        rc = 6;
                    }
                } else if (RemoveEntriesForMissingFiles.checkTable(instance, principal, token, checkTabletsCommand.table, checkTabletsCommand.fixFiles) != 0) {
                    rc = 6;
                }
            } else if (cl.getParsedCommand().equals("stop")) {
                Admin.stopTabletServer(instance, new Credentials(principal, token), stopOpts.args, opts.force);
            } else if (cl.getParsedCommand().equals("dumpConfig")) {
                Admin.printConfig(instance, principal, token, dumpConfigCommand);
            } else if (cl.getParsedCommand().equals("volumes")) {
                ListVolumesUsed.listVolumes(instance, principal, token);
            } else if (cl.getParsedCommand().equals("randomizeVolumes")) {
                rc = RandomizeVolumes.randomize(instance.getConnector(principal, token), randomizeVolumesOpts.table);
            } else {
                boolean everything = cl.getParsedCommand().equals("stopAll");
                if (everything) {
                    Admin.flushAll(instance, principal, token);
                }
                Admin.stopServer(instance, new Credentials(principal, token), everything);
            }
            if (rc != 0) {
                System.exit(rc);
            }
        }
        catch (AccumuloException e) {
            log.error((Object)e, (Throwable)e);
            System.exit(1);
        }
        catch (AccumuloSecurityException e) {
            log.error((Object)e, (Throwable)e);
            System.exit(2);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            System.exit(3);
        }
    }

    private static int ping(Instance instance, String principal, AuthenticationToken token, List<String> args) throws AccumuloException, AccumuloSecurityException {
        InstanceOperations io = instance.getConnector(principal, token).instanceOperations();
        if (args.size() == 0) {
            args = io.getTabletServers();
        }
        int unreachable = 0;
        for (String tserver : args) {
            try {
                io.ping(tserver);
                System.out.println(tserver + " OK");
            }
            catch (AccumuloException ae) {
                System.out.println(tserver + " FAILED (" + ae.getMessage() + ")");
                ++unreachable;
            }
        }
        System.out.printf("\n%d of %d tablet servers unreachable\n\n", unreachable, args.size());
        return unreachable;
    }

    private static void flushAll(final Instance instance, final String principal, final AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        final AtomicInteger flushesStarted = new AtomicInteger(0);
        Runnable flushTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Connector conn = instance.getConnector(principal, token);
                    Set tables = conn.tableOperations().tableIdMap().keySet();
                    for (String table : tables) {
                        if (table.equals("accumulo.metadata")) continue;
                        try {
                            conn.tableOperations().flush(table, null, null, false);
                            flushesStarted.incrementAndGet();
                        }
                        catch (TableNotFoundException e) {}
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to intiate flush " + e.getMessage()));
                }
            }
        };
        Thread flusher = new Thread(flushTask);
        flusher.setDaemon(true);
        flusher.start();
        long start = System.currentTimeMillis();
        try {
            flusher.join(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        while (flusher.isAlive() && System.currentTimeMillis() - start < 15000L) {
            int flushCount = flushesStarted.get();
            try {
                flusher.join(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (flushCount != flushesStarted.get()) continue;
            break;
        }
    }

    private static void stopServer(final Instance instance, final Credentials credentials, final boolean tabletServersToo) throws AccumuloException, AccumuloSecurityException {
        MasterClient.execute((Instance)instance, (ClientExec)new ClientExec<MasterClientService.Client>(){

            public void execute(MasterClientService.Client client) throws Exception {
                client.shutdown(Tracer.traceInfo(), credentials.toThrift(instance), tabletServersToo);
            }
        });
    }

    private static void stopTabletServer(final Instance instance, final Credentials creds, List<String> servers, final boolean force) throws AccumuloException, AccumuloSecurityException {
        if (instance.getMasterLocations().size() == 0) {
            log.info((Object)"No masters running. Not attempting safe unload of tserver.");
            return;
        }
        for (String server : servers) {
            HostAndPort address = AddressUtil.parseAddress((String)server, (int)ServerConfiguration.getDefaultConfiguration().getPort(Property.TSERV_CLIENTPORT));
            final String finalServer = address.toString();
            log.info((Object)("Stopping server " + finalServer));
            MasterClient.execute((Instance)instance, (ClientExec)new ClientExec<MasterClientService.Client>(){

                public void execute(MasterClientService.Client client) throws Exception {
                    client.shutdownTabletServer(Tracer.traceInfo(), creds.toThrift(instance), finalServer, force);
                }
            });
        }
    }

    public static void printConfig(Instance instance, String principal, AuthenticationToken token, DumpConfigCommand opts) throws Exception {
        block14: {
            Connector connector;
            File outputDirectory;
            block13: {
                outputDirectory = null;
                if (opts.directory != null) {
                    outputDirectory = new File(opts.directory);
                    if (!outputDirectory.isDirectory()) {
                        throw new IllegalArgumentException(opts.directory + " does not exist on the local filesystem.");
                    }
                    if (!outputDirectory.canWrite()) {
                        throw new IllegalArgumentException(opts.directory + " is not writable");
                    }
                }
                connector = instance.getConnector(principal, token);
                defaultConfig = AccumuloConfiguration.getDefaultConfiguration();
                siteConfig = connector.instanceOperations().getSiteConfiguration();
                systemConfig = connector.instanceOperations().getSystemConfiguration();
                if (opts.allConfiguration || opts.users) {
                    localUsers = Lists.newArrayList((Iterable)connector.securityOperations().listLocalUsers());
                    Collections.sort(localUsers);
                }
                if (!opts.allConfiguration) break block13;
                Admin.printSystemConfiguration(connector, outputDirectory);
                for (String namespace : connector.namespaceOperations().list()) {
                    Admin.printNameSpaceConfiguration(connector, namespace, outputDirectory);
                }
                SortedSet tableNames = connector.tableOperations().list();
                for (String tableName : tableNames) {
                    Admin.printTableConfiguration(connector, tableName, outputDirectory);
                }
                for (String user : localUsers) {
                    Admin.printUserConfiguration(connector, user, outputDirectory);
                }
                break block14;
            }
            if (opts.systemConfiguration) {
                Admin.printSystemConfiguration(connector, outputDirectory);
            }
            if (opts.namespaceConfiguration) {
                for (String namespace : connector.namespaceOperations().list()) {
                    Admin.printNameSpaceConfiguration(connector, namespace, outputDirectory);
                }
            }
            if (opts.tables.size() > 0) {
                for (String tableName : opts.tables) {
                    Admin.printTableConfiguration(connector, tableName, outputDirectory);
                }
            }
            if (!opts.users) break block14;
            for (String user : localUsers) {
                Admin.printUserConfiguration(connector, user, outputDirectory);
            }
        }
    }

    private static String getDefaultConfigValue(String key) {
        if (null == key) {
            return null;
        }
        String defaultValue = null;
        try {
            Property p = Property.getPropertyByKey((String)key);
            if (null == p) {
                return defaultValue;
            }
            defaultValue = defaultConfig.get(p);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return defaultValue;
    }

    private static void printNameSpaceConfiguration(Connector connector, String namespace, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException, NamespaceNotFoundException {
        File namespaceScript = new File(outputDirectory, namespace + NS_FILE_SUFFIX);
        FileWriter nsWriter = new FileWriter(namespaceScript);
        nsWriter.write(createNsFormat.format(new String[]{namespace}));
        TreeMap props = new TreeMap();
        for (Map.Entry entry : connector.namespaceOperations().getProperties(namespace)) {
            props.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : props.entrySet()) {
            String defaultValue = Admin.getDefaultConfigValue((String)entry.getKey());
            if (defaultValue != null && defaultValue.equals(entry.getValue()) || ((String)entry.getValue()).equals(siteConfig.get(entry.getKey())) || ((String)entry.getValue()).equals(systemConfig.get(entry.getKey()))) continue;
            nsWriter.write(nsConfigFormat.format(new String[]{namespace, (String)entry.getKey() + "=" + (String)entry.getValue()}));
        }
        nsWriter.close();
    }

    private static void printUserConfiguration(Connector connector, String user, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException {
        File userScript = new File(outputDirectory, user + USER_FILE_SUFFIX);
        FileWriter userWriter = new FileWriter(userScript);
        userWriter.write(createUserFormat.format(new String[]{user}));
        Authorizations auths = connector.securityOperations().getUserAuthorizations(user);
        userWriter.write(userAuthsFormat.format(new String[]{user, auths.toString()}));
        for (SystemPermission sp : SystemPermission.values()) {
            if (!connector.securityOperations().hasSystemPermission(user, sp)) continue;
            userWriter.write(sysPermFormat.format(new String[]{sp.name(), user}));
        }
        for (String namespace : connector.namespaceOperations().list()) {
            NamespacePermission[] arr$ = NamespacePermission.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                NamespacePermission np = arr$[i$];
                if (!connector.securityOperations().hasNamespacePermission(user, namespace, np)) continue;
                userWriter.write(nsPermFormat.format(new String[]{np.name(), namespace, user}));
            }
        }
        for (String tableName : connector.tableOperations().list()) {
            for (TablePermission perm : TablePermission.values()) {
                if (!connector.securityOperations().hasTablePermission(user, tableName, perm)) continue;
                userWriter.write(tablePermFormat.format(new String[]{perm.name(), tableName, user}));
            }
        }
        userWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemConfiguration(Connector connector, File outputDirectory) throws IOException, AccumuloException, AccumuloSecurityException {
        Configuration conf = new Configuration(false);
        TreeMap<String, String> site = new TreeMap<String, String>(siteConfig);
        for (Map.Entry<String, String> prop : site.entrySet()) {
            String defaultValue = Admin.getDefaultConfigValue(prop.getKey());
            if (prop.getValue().equals(defaultValue) || systemConfig.containsKey(prop.getKey())) continue;
            conf.set(prop.getKey(), prop.getValue());
        }
        TreeMap<String, String> system = new TreeMap<String, String>(systemConfig);
        for (Map.Entry<String, String> prop : system.entrySet()) {
            String defaultValue = Admin.getDefaultConfigValue(prop.getKey());
            if (prop.getValue().equals(defaultValue)) continue;
            conf.set(prop.getKey(), prop.getValue());
        }
        File siteBackup = new File(outputDirectory, ACCUMULO_SITE_BACKUP_FILE);
        FileOutputStream fos = new FileOutputStream(siteBackup);
        try {
            conf.writeXml((OutputStream)fos);
        }
        finally {
            fos.close();
        }
    }

    private static void printTableConfiguration(Connector connector, String tableName, File outputDirectory) throws AccumuloException, TableNotFoundException, IOException, AccumuloSecurityException {
        File tableBackup = new File(outputDirectory, tableName + ".cfg");
        FileWriter writer = new FileWriter(tableBackup);
        writer.write(createTableFormat.format(new String[]{tableName}));
        TreeMap props = new TreeMap();
        for (Map.Entry entry : connector.tableOperations().getProperties(tableName)) {
            props.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : props.entrySet()) {
            String defaultValue;
            if (!((String)entry.getKey()).startsWith(Property.TABLE_PREFIX.getKey()) || (defaultValue = Admin.getDefaultConfigValue((String)entry.getKey())) != null && defaultValue.equals(entry.getValue()) || ((String)entry.getValue()).equals(siteConfig.get(entry.getKey())) || ((String)entry.getValue()).equals(systemConfig.get(entry.getKey()))) continue;
            writer.write(configFormat.format(new String[]{tableName, (String)entry.getKey() + "=" + (String)entry.getValue()}));
        }
        writer.close();
    }

    @Parameters(commandDescription="redistribute tablet directories across the current volume list")
    static class RandomizeVolumesCommand {
        @Parameter(names={"-t"}, description="table to update", required=true)
        String table = null;

        RandomizeVolumesCommand() {
        }
    }

    @Parameters(commandDescription="print out non-default configuration settings")
    static class DumpConfigCommand {
        @Parameter(names={"-a", "--all"}, description="print the system and all table configurations")
        boolean allConfiguration = false;
        @Parameter(names={"-d", "--directory"}, description="directory to place config files")
        String directory = null;
        @Parameter(names={"-s", "--system"}, description="print the system configuration")
        boolean systemConfiguration = false;
        @Parameter(names={"-n", "--namespaces"}, description="print the namespace configuration")
        boolean namespaceConfiguration = false;
        @Parameter(names={"-t", "--tables"}, description="print per-table configuration")
        List<String> tables = new ArrayList<String>();
        @Parameter(names={"-u", "--users"}, description="print users and their authorizations and permissions")
        boolean users = false;

        DumpConfigCommand() {
        }
    }

    @Parameters(commandDescription="Accumulo volume utility")
    static class VolumesCommand {
        @Parameter(names={"-l", "--list"}, description="list volumes currently in use")
        boolean printErrors = false;

        VolumesCommand() {
        }
    }

    @Parameters(commandDescription="list Accumulo instances in zookeeper")
    static class ListInstancesCommand {
        @Parameter(names={"--print-errors"}, description="display errors while listing instances")
        boolean printErrors = false;
        @Parameter(names={"--print-all"}, description="print information for all instances, not just those with names")
        boolean printAll = false;

        ListInstancesCommand() {
        }
    }

    @Parameters(commandDescription="stop all the servers")
    static class StopAllCommand {
        StopAllCommand() {
        }
    }

    @Parameters(commandDescription="stop the master")
    static class StopMasterCommand {
        StopMasterCommand() {
        }
    }

    @Parameters(commandDescription="print tablets that are offline in online tables")
    static class CheckTabletsCommand {
        @Parameter(names={"--fixFiles"}, description="Remove dangling file pointers")
        boolean fixFiles = false;
        @Parameter(names={"-t", "--table"}, description="Table to check, if not set checks all tables")
        String table = null;

        CheckTabletsCommand() {
        }
    }

    @Parameters(commandDescription="Ping tablet servers.  If no arguments, pings all.")
    static class PingCommand {
        @Parameter(description="{<host> ... }")
        List<String> args = new ArrayList<String>();

        PingCommand() {
        }
    }

    @Parameters(commandDescription="stop the tablet server on the given hosts")
    static class StopCommand {
        @Parameter(description="<host> {<host> ... }")
        List<String> args = new ArrayList<String>();

        StopCommand() {
        }
    }

    static class AdminOpts
    extends ClientOpts {
        @Parameter(names={"-f", "--force"}, description="force the given server to stop by removing its lock")
        boolean force = false;

        AdminOpts() {
        }
    }
}

