/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import com.google.common.base.Charsets;
import java.util.HashSet;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;

public class DeleteZooInstance {
    static void deleteRetry(IZooReaderWriter zk, String path) throws Exception {
        for (int i = 0; i < 10; ++i) {
            try {
                zk.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
                return;
            }
            catch (KeeperException.NotEmptyException ex) {
                continue;
            }
            catch (Exception ex) {
                throw ex;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(DeleteZooInstance.class.getName(), args, new Object[0]);
        ZooReaderWriter zk = ZooReaderWriter.getInstance();
        HashSet instances = new HashSet(zk.getChildren("/accumulo/instances"));
        HashSet uuids = new HashSet(zk.getChildren("/accumulo"));
        uuids.remove("instances");
        if (instances.contains(opts.instance)) {
            String path = "/accumulo/instances/" + opts.instance;
            byte[] data = zk.getData(path, null);
            DeleteZooInstance.deleteRetry((IZooReaderWriter)zk, path);
            DeleteZooInstance.deleteRetry((IZooReaderWriter)zk, "/accumulo/" + new String(data, Charsets.UTF_8));
        } else if (uuids.contains(opts.instance)) {
            for (String instance : instances) {
                String path = "/accumulo/instances/" + instance;
                byte[] data = zk.getData(path, null);
                if (!opts.instance.equals(new String(data, Charsets.UTF_8))) continue;
                DeleteZooInstance.deleteRetry((IZooReaderWriter)zk, path);
            }
            DeleteZooInstance.deleteRetry((IZooReaderWriter)zk, "/accumulo/" + opts.instance);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-i", "--instance"}, description="the instance name or id to delete")
        String instance;

        Opts() {
        }
    }
}

