/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class RemoveEntriesForMissingFiles {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int checkTable(Instance instance, String principal, AuthenticationToken token, String table, Range range, boolean fix) throws Exception {
        LRUMap cache = new LRUMap(100000);
        HashSet<Path> processing = new HashSet<Path>();
        ExecutorService threadPool = Executors.newFixedThreadPool(16);
        System.out.printf("Scanning : %s %s\n", table, range);
        VolumeManager fs = VolumeManagerImpl.get();
        Connector connector = instance.getConnector(principal, token);
        Scanner metadata = connector.createScanner(table, Authorizations.EMPTY);
        metadata.setRange(range);
        metadata.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        int count = 0;
        AtomicInteger missing = new AtomicInteger(0);
        AtomicReference<Object> exceptionRef = new AtomicReference<Object>(null);
        BatchWriter writer = null;
        if (fix) {
            writer = connector.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        }
        for (Map.Entry entry : metadata) {
            if (exceptionRef.get() != null) break;
            ++count;
            Key key = (Key)entry.getKey();
            Path map = fs.getFullPath(key);
            HashSet<Path> hashSet = processing;
            synchronized (hashSet) {
                while (processing.size() >= 64 || processing.contains(map)) {
                    processing.wait();
                }
                if (cache.get(map) != null) {
                    continue;
                }
                processing.add(map);
            }
            threadPool.submit(new CheckFileTask((Map)cache, fs, missing, writer, key, map, processing, exceptionRef));
        }
        threadPool.shutdown();
        HashSet<Path> hashSet = processing;
        synchronized (hashSet) {
            while (processing.size() > 0) {
                processing.wait();
            }
        }
        if (exceptionRef.get() != null) {
            throw new AccumuloException((Throwable)exceptionRef.get());
        }
        if (writer != null && missing.get() > 0) {
            writer.close();
        }
        System.out.printf("Scan finished, %d files of %d missing\n\n", missing.get(), count);
        return missing.get();
    }

    static int checkAllTables(Instance instance, String principal, AuthenticationToken token, boolean fix) throws Exception {
        int missing = RemoveEntriesForMissingFiles.checkTable(instance, principal, token, "accumulo.root", MetadataSchema.TabletsSection.getRange(), fix);
        if (missing == 0) {
            return RemoveEntriesForMissingFiles.checkTable(instance, principal, token, "accumulo.metadata", MetadataSchema.TabletsSection.getRange(), fix);
        }
        return missing;
    }

    static int checkTable(Instance instance, String principal, AuthenticationToken token, String tableName, boolean fix) throws Exception {
        if (tableName.equals("accumulo.root")) {
            throw new IllegalArgumentException("Can not check root table");
        }
        if (tableName.equals("accumulo.metadata")) {
            return RemoveEntriesForMissingFiles.checkTable(instance, principal, token, "accumulo.root", MetadataSchema.TabletsSection.getRange(), fix);
        }
        String tableId = Tables.getTableId((Instance)instance, (String)tableName);
        Range range = new KeyExtent(new Text(tableId), null, null).toMetadataRange();
        return RemoveEntriesForMissingFiles.checkTable(instance, principal, token, "accumulo.metadata", range, fix);
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        ScannerOpts scanOpts = new ScannerOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(RemoveEntriesForMissingFiles.class.getName(), args, new Object[]{scanOpts, bwOpts});
        RemoveEntriesForMissingFiles.checkAllTables(opts.getInstance(), opts.principal, opts.getToken(), opts.fix);
    }

    private static class CheckFileTask
    implements Runnable {
        private Map cache;
        private VolumeManager fs;
        private AtomicInteger missing;
        private BatchWriter writer;
        private Key key;
        private Path path;
        private Set<Path> processing;
        private AtomicReference<Exception> exceptionRef;

        CheckFileTask(Map cache, VolumeManager fs, AtomicInteger missing, BatchWriter writer, Key key, Path map, Set<Path> processing, AtomicReference<Exception> exceptionRef) {
            this.cache = cache;
            this.fs = fs;
            this.missing = missing;
            this.writer = writer;
            this.key = key;
            this.path = map;
            this.processing = processing;
            this.exceptionRef = exceptionRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block20: {
                try {
                    Object m;
                    if (!this.fs.exists(this.path)) {
                        this.missing.incrementAndGet();
                        m = new Mutation(this.key.getRow());
                        m.putDelete(this.key.getColumnFamily(), this.key.getColumnQualifier());
                        if (this.writer != null) {
                            this.writer.addMutation(m);
                            System.out.println("Reference " + this.path + " removed from " + this.key.getRow());
                        } else {
                            System.out.println("File " + this.path + " is missing");
                        }
                        break block20;
                    }
                    m = this.processing;
                    synchronized (m) {
                        this.cache.put(this.path, this.path);
                    }
                }
                catch (Exception e) {
                    this.exceptionRef.compareAndSet(null, e);
                }
                finally {
                    Set<Path> set = this.processing;
                    synchronized (set) {
                        this.processing.remove(this.path);
                        this.processing.notify();
                    }
                }
            }
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--fix"})
        boolean fix = false;

        Opts() {
        }
    }
}

