/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.base.Charsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;

public class SystemPropUtil {
    public static boolean setSystemProperty(String property, String value) throws KeeperException, InterruptedException {
        Property p = Property.getPropertyByKey((String)property);
        if (p != null && !p.getType().isValidFormat(value) || !Property.isValidZooPropertyKey((String)property)) {
            return false;
        }
        String zPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/config" + "/" + property;
        ZooReaderWriter.getInstance().putPersistentData(zPath, value.getBytes(Charsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return true;
    }

    public static void removeSystemProperty(String property) throws InterruptedException, KeeperException {
        String zPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/config" + "/" + property;
        ZooReaderWriter.getInstance().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.FAIL);
    }
}

