/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.LoggingRunnable;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.core.util.SslConnectionParams;
import org.apache.accumulo.core.util.TBufferedSocket;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.metrics.ThriftMetrics;
import org.apache.accumulo.server.util.CustomNonBlockingServer;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.TBufferedServerSocket;
import org.apache.accumulo.server.util.TNonblockingServerSocket;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TServerUtils {
    private static final Logger log = Logger.getLogger(TServerUtils.class);
    public static final ThreadLocal<String> clientAddress = new ThreadLocal();

    public static ServerAddress startServer(AccumuloConfiguration conf, String address, Property portHintProperty, TProcessor processor, String serverName, String threadName, Property portSearchProperty, Property minThreadProperty, Property timeBetweenThreadChecksProperty, Property maxMessageSizeProperty) throws UnknownHostException {
        int portHint = conf.getPort(portHintProperty);
        int minThreads = 2;
        if (minThreadProperty != null) {
            minThreads = conf.getCount(minThreadProperty);
        }
        long timeBetweenThreadChecks = 1000L;
        if (timeBetweenThreadChecksProperty != null) {
            timeBetweenThreadChecks = conf.getTimeInMillis(timeBetweenThreadChecksProperty);
        }
        long maxMessageSize = 10000000L;
        if (maxMessageSizeProperty != null) {
            maxMessageSize = conf.getMemoryInBytes(maxMessageSizeProperty);
        }
        boolean portSearch = false;
        if (portSearchProperty != null) {
            portSearch = conf.getBoolean(portSearchProperty);
        }
        TimedProcessor timedProcessor = new TimedProcessor(processor, serverName, threadName);
        Random random = new Random();
        block2: for (int j = 0; j < 100; ++j) {
            int portsToSearch = 1;
            if (portSearch) {
                portsToSearch = 1000;
            }
            for (int i = 0; i < portsToSearch; ++i) {
                int port = portHint + i;
                if (portHint != 0 && i > 0) {
                    port = 1024 + random.nextInt(64511);
                }
                if (port > 65535) {
                    port = 1024 + port % 64511;
                }
                try {
                    HostAndPort addr = HostAndPort.fromParts((String)address, (int)port);
                    return TServerUtils.startTServer(addr, timedProcessor, serverName, threadName, minThreads, timeBetweenThreadChecks, maxMessageSize, SslConnectionParams.forServer((AccumuloConfiguration)conf), conf.getTimeInMillis(Property.GENERAL_RPC_TIMEOUT));
                }
                catch (TTransportException ex) {
                    log.error((Object)"Unable to start TServer", (Throwable)ex);
                    if (ex.getCause() != null && ex.getCause().getClass() != BindException.class) {
                        log.error((Object)"Unable to start TServer", (Throwable)ex);
                        continue block2;
                    }
                    log.info((Object)("Unable to use port " + port + ", retrying. (Thread Name = " + threadName + ")"));
                    UtilWaitThread.sleep((long)250L);
                    continue;
                }
            }
        }
        throw new UnknownHostException("Unable to find a listen port");
    }

    public static ServerAddress createNonBlockingServer(HostAndPort address, TProcessor processor, String serverName, String threadName, int numThreads, long timeBetweenThreadChecks, long maxMessageSize) throws TTransportException {
        TNonblockingServerSocket transport = new TNonblockingServerSocket(new InetSocketAddress(address.getHostText(), address.getPort()));
        THsHaServer.Args options = new THsHaServer.Args((TNonblockingServerTransport)transport);
        options.protocolFactory(ThriftUtil.protocolFactory());
        options.transportFactory(ThriftUtil.transportFactory((long)maxMessageSize));
        options.maxReadBufferBytes = maxMessageSize;
        options.stopTimeoutVal(5);
        SimpleThreadPool pool = new SimpleThreadPool(numThreads, "ClientPool");
        SimpleTimer.getInstance().schedule(new Runnable((ThreadPoolExecutor)pool, serverName, numThreads){
            final /* synthetic */ ThreadPoolExecutor val$pool;
            final /* synthetic */ String val$serverName;
            final /* synthetic */ int val$numThreads;
            {
                this.val$pool = threadPoolExecutor;
                this.val$serverName = string;
                this.val$numThreads = n;
            }

            @Override
            public void run() {
                int smaller;
                if (this.val$pool.getCorePoolSize() <= this.val$pool.getActiveCount()) {
                    int larger = this.val$pool.getCorePoolSize() + Math.min(this.val$pool.getQueue().size(), 2);
                    log.info((Object)("Increasing server thread pool size on " + this.val$serverName + " to " + larger));
                    this.val$pool.setMaximumPoolSize(larger);
                    this.val$pool.setCorePoolSize(larger);
                } else if (this.val$pool.getCorePoolSize() > this.val$pool.getActiveCount() + 3 && (smaller = Math.max(this.val$numThreads, this.val$pool.getCorePoolSize() - 1)) != this.val$pool.getCorePoolSize()) {
                    log.info((Object)("Decreasing server thread pool size on " + this.val$serverName + " to " + smaller));
                    this.val$pool.setCorePoolSize(smaller);
                }
            }
        }, timeBetweenThreadChecks, timeBetweenThreadChecks);
        options.executorService((ExecutorService)pool);
        options.processorFactory(new TProcessorFactory(processor));
        if (address.getPort() == 0) {
            address = HostAndPort.fromParts((String)address.getHostText(), (int)transport.getPort());
        }
        return new ServerAddress((TServer)new CustomNonBlockingServer(options), address);
    }

    public static ServerAddress createThreadPoolServer(HostAndPort address, TProcessor processor, String serverName, String threadName, int numThreads) throws TTransportException {
        ServerSocket sock;
        try {
            sock = ServerSocketChannel.open().socket();
            sock.setReuseAddress(true);
            sock.bind(new InetSocketAddress(address.getHostText(), address.getPort()));
            address = HostAndPort.fromParts((String)address.getHostText(), (int)sock.getLocalPort());
        }
        catch (IOException ex) {
            throw new TTransportException((Throwable)ex);
        }
        TBufferedServerSocket transport = new TBufferedServerSocket(sock, 32768);
        return new ServerAddress(TServerUtils.createThreadPoolServer(transport, processor), address);
    }

    public static TServer createThreadPoolServer(TServerTransport transport, TProcessor processor) {
        TThreadPoolServer.Args options = new TThreadPoolServer.Args(transport);
        options.protocolFactory(ThriftUtil.protocolFactory());
        options.transportFactory(ThriftUtil.transportFactory());
        options.processorFactory((TProcessorFactory)new ClientInfoProcessorFactory(processor));
        return new TThreadPoolServer(options);
    }

    public static ServerAddress createSslThreadPoolServer(HostAndPort address, TProcessor processor, long socketTimeout, SslConnectionParams sslParams) throws TTransportException {
        TServerSocket transport;
        try {
            transport = ThriftUtil.getServerSocket((int)address.getPort(), (int)((int)socketTimeout), (InetAddress)InetAddress.getByName(address.getHostText()), (SslConnectionParams)sslParams);
        }
        catch (UnknownHostException e) {
            throw new TTransportException((Throwable)e);
        }
        if (address.getPort() == 0) {
            address = HostAndPort.fromParts((String)address.getHostText(), (int)transport.getServerSocket().getLocalPort());
        }
        return new ServerAddress(TServerUtils.createThreadPoolServer((TServerTransport)transport, processor), address);
    }

    public static ServerAddress startTServer(HostAndPort address, TProcessor processor, String serverName, String threadName, int numThreads, long timeBetweenThreadChecks, long maxMessageSize, SslConnectionParams sslParams, long sslSocketTimeout) throws TTransportException {
        return TServerUtils.startTServer(address, new TimedProcessor(processor, serverName, threadName), serverName, threadName, numThreads, timeBetweenThreadChecks, maxMessageSize, sslParams, sslSocketTimeout);
    }

    public static ServerAddress startTServer(HostAndPort address, TimedProcessor processor, String serverName, String threadName, int numThreads, long timeBetweenThreadChecks, long maxMessageSize, SslConnectionParams sslParams, long sslSocketTimeout) throws TTransportException {
        ServerAddress serverAddress = sslParams != null ? TServerUtils.createSslThreadPoolServer(address, processor, sslSocketTimeout, sslParams) : TServerUtils.createNonBlockingServer(address, processor, serverName, threadName, numThreads, timeBetweenThreadChecks, maxMessageSize);
        final TServer finalServer = serverAddress.server;
        Runnable serveTask = new Runnable(){

            @Override
            public void run() {
                try {
                    finalServer.serve();
                }
                catch (Error e) {
                    Halt.halt("Unexpected error in TThreadPoolServer " + e + ", halting.", 1);
                }
            }
        };
        serveTask = new LoggingRunnable(log, serveTask);
        Daemon thread = new Daemon(serveTask, threadName);
        thread.start();
        if (serverAddress.address.getHostText().equals("0.0.0.0")) {
            try {
                serverAddress = new ServerAddress(finalServer, HostAndPort.fromParts((String)InetAddress.getLocalHost().getHostName(), (int)serverAddress.address.getPort()));
            }
            catch (UnknownHostException e) {
                throw new TTransportException((Throwable)e);
            }
        }
        return serverAddress;
    }

    public static void stopTServer(TServer s) {
        if (s == null) {
            return;
        }
        s.stop();
        try {
            Field f = s.getClass().getDeclaredField("executorService_");
            f.setAccessible(true);
            ExecutorService es = (ExecutorService)f.get(s);
            es.shutdownNow();
        }
        catch (Exception e) {
            log.error((Object)"Unable to call shutdownNow", (Throwable)e);
        }
    }

    public static class ClientInfoProcessorFactory
    extends TProcessorFactory {
        public ClientInfoProcessorFactory(TProcessor processor) {
            super(processor);
        }

        public TProcessor getProcessor(TTransport trans) {
            if (trans instanceof TBufferedSocket) {
                TBufferedSocket tsock = (TBufferedSocket)trans;
                clientAddress.set(tsock.getClientString());
            } else if (trans instanceof TSocket) {
                TSocket tsock = (TSocket)trans;
                clientAddress.set(tsock.getSocket().getInetAddress().getHostAddress() + ":" + tsock.getSocket().getPort());
            } else {
                log.warn((Object)("Unable to extract clientAddress from transport of type " + trans.getClass()));
            }
            return super.getProcessor(trans);
        }
    }

    public static class TimedProcessor
    implements TProcessor {
        final TProcessor other;
        ThriftMetrics metrics = null;
        long idleStart = 0L;

        TimedProcessor(TProcessor next, String serverName, String threadName) {
            this.other = next;
            try {
                this.metrics = new ThriftMetrics(serverName, threadName);
                this.metrics.register();
            }
            catch (Exception e) {
                log.error((Object)"Exception registering MBean with MBean Server", (Throwable)e);
            }
            this.idleStart = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(TProtocol in, TProtocol out) throws TException {
            long now = 0L;
            if (this.metrics.isEnabled()) {
                now = System.currentTimeMillis();
                this.metrics.add("idle", now - this.idleStart);
            }
            try {
                boolean bl = this.other.process(in, out);
                return bl;
            }
            finally {
                if (this.metrics.isEnabled()) {
                    this.idleStart = System.currentTimeMillis();
                    this.metrics.add("execute", this.idleStart - now);
                }
            }
        }
    }

    public static class ServerAddress {
        public final TServer server;
        public final HostAndPort address;

        public ServerAddress(TServer server, HostAndPort address) {
            this.server = server;
            this.address = address;
        }
    }
}

