/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.common.base.Charsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;

public class TablePropUtil {
    public static boolean setTableProperty(String tableId, String property, String value) throws KeeperException, InterruptedException {
        if (!TablePropUtil.isPropertyValid(property, value)) {
            return false;
        }
        String zkTablePath = TablePropUtil.getTablePath(tableId);
        ZooReaderWriter.getInstance().putPersistentData(zkTablePath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        String zPath = zkTablePath + "/" + property;
        ZooReaderWriter.getInstance().putPersistentData(zPath, value.getBytes(Charsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return true;
    }

    public static boolean isPropertyValid(String property, String value) {
        Property p = Property.getPropertyByKey((String)property);
        return (p == null || p.getType().isValidFormat(value)) && Property.isValidTablePropertyKey((String)property);
    }

    public static void removeTableProperty(String tableId, String property) throws InterruptedException, KeeperException {
        String zPath = TablePropUtil.getTablePath(tableId) + "/" + property;
        ZooReaderWriter.getInstance().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.SKIP);
    }

    private static String getTablePath(String tablename) {
        return ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/tables" + "/" + tablename + "/conf";
    }
}

