/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class TabletOperations {
    private static final Logger log = Logger.getLogger(TabletOperations.class);

    public static String createTabletDirectory(VolumeManager fs, String tableId, Text endRow) {
        UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
        String volume = fs.choose(ServerConstants.getBaseUris()) + "/tables" + "/";
        while (true) {
            try {
                Path lowDirectoryPath;
                String lowDirectory;
                if (endRow == null) {
                    lowDirectory = "/default_tablet";
                    lowDirectoryPath = new Path(volume + "/" + tableId + "/" + lowDirectory);
                    if (fs.exists(lowDirectoryPath) || fs.mkdirs(lowDirectoryPath)) {
                        FileSystem pathFs = fs.getVolumeByPath(lowDirectoryPath).getFileSystem();
                        return lowDirectoryPath.makeQualified(pathFs.getUri(), pathFs.getWorkingDirectory()).toString();
                    }
                    log.warn((Object)("Failed to create " + lowDirectoryPath + " for unknown reason"));
                } else {
                    lowDirectory = "/t-" + namer.getNextName();
                    lowDirectoryPath = new Path(volume + "/" + tableId + "/" + lowDirectory);
                    if (fs.exists(lowDirectoryPath)) {
                        throw new IllegalStateException("Dir exist when it should not " + lowDirectoryPath);
                    }
                    if (fs.mkdirs(lowDirectoryPath)) {
                        FileSystem lowDirectoryFs = fs.getVolumeByPath(lowDirectoryPath).getFileSystem();
                        return lowDirectoryPath.makeQualified(lowDirectoryFs.getUri(), lowDirectoryFs.getWorkingDirectory()).toString();
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
            log.warn((Object)("Failed to create dir for tablet in table " + tableId + " in volume " + volume + " + will retry ..."));
            UtilWaitThread.sleep((long)3000L);
        }
    }

    public static String createTabletDirectory(String tableDir, Text endRow) {
        while (true) {
            try {
                VolumeManager fs = VolumeManagerImpl.get();
                return TabletOperations.createTabletDirectory(fs, tableDir, endRow);
            }
            catch (IOException e) {
                log.warn((Object)"problem creating tablet directory", (Throwable)e);
            }
            catch (IllegalArgumentException exception) {
                if (exception.getCause() instanceof UnknownHostException) {
                    log.warn((Object)"problem creating tablet directory", (Throwable)exception);
                }
                throw exception;
            }
            UtilWaitThread.sleep((long)3000L);
        }
    }
}

