/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import com.google.common.base.Charsets;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;

public class TabletServerLocks {
    public static void main(String[] args) throws Exception {
        Instance instance = HdfsZooInstance.getInstance();
        String tserverPath = ZooUtil.getRoot((Instance)instance) + "/tservers";
        Opts opts = new Opts();
        opts.parseArgs(TabletServerLocks.class.getName(), args, new Object[0]);
        ZooCache cache = new ZooCache(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut());
        if (opts.list) {
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            List tabletServers = zoo.getChildren(tserverPath);
            for (String tabletServer : tabletServers) {
                byte[] lockData = ZooLock.getLockData((ZooCache)cache, (String)(tserverPath + "/" + tabletServer), null);
                String holder = null;
                if (lockData != null) {
                    holder = new String(lockData, Charsets.UTF_8);
                }
                System.out.printf("%32s %16s%n", tabletServer, holder);
            }
        } else if (opts.delete != null) {
            ZooLock.deleteLock(tserverPath + "/" + args[1]);
        } else {
            System.out.println("Usage : " + TabletServerLocks.class.getName() + " -list|-delete <tserver lock>");
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-list"})
        boolean list = false;
        @Parameter(names={"-delete"})
        String delete = null;

        Opts() {
        }
    }
}

