/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.List;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;

public class ZooZap {
    private static void message(String msg, Opts opts) {
        if (opts.verbose) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(ZooZap.class.getName(), args, new Object[0]);
        if (!(opts.zapMaster || opts.zapTservers || opts.zapTracers)) {
            new JCommander((Object)opts).usage();
            return;
        }
        String iid = opts.getInstance().getInstanceID();
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        if (opts.zapMaster) {
            String masterLockPath = "/accumulo/" + iid + "/masters/lock";
            try {
                ZooZap.zapDirectory((IZooReaderWriter)zoo, masterLockPath, opts);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (opts.zapTservers) {
            String tserversPath = "/accumulo/" + iid + "/tservers";
            try {
                List children = zoo.getChildren(tserversPath);
                for (String child : children) {
                    ZooZap.message("Deleting " + tserversPath + "/" + child + " from zookeeper", opts);
                    if (opts.zapMaster) {
                        ZooReaderWriter.getInstance().recursiveDelete(tserversPath + "/" + child, ZooUtil.NodeMissingPolicy.SKIP);
                        continue;
                    }
                    String path = tserversPath + "/" + child;
                    if (zoo.getChildren(path).size() <= 0 || ZooLock.deleteLock(path, "tserver")) continue;
                    ZooZap.message("Did not delete " + tserversPath + "/" + child, opts);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (opts.zapTracers) {
            String path = "/accumulo/" + iid + "/tracers";
            try {
                ZooZap.zapDirectory((IZooReaderWriter)zoo, path, opts);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void zapDirectory(IZooReaderWriter zoo, String path, Opts opts) throws KeeperException, InterruptedException {
        List children = zoo.getChildren(path);
        for (String child : children) {
            ZooZap.message("Deleting " + path + "/" + child + " from zookeeper", opts);
            zoo.recursiveDelete(path + "/" + child, ZooUtil.NodeMissingPolicy.SKIP);
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"-master"}, description="remove master locks")
        boolean zapMaster = false;
        @Parameter(names={"-tservers"}, description="remove tablet server locks")
        boolean zapTservers = false;
        @Parameter(names={"-tracers"}, description="remove tracer locks")
        boolean zapTracers = false;
        @Parameter(names={"-verbose"}, description="print out messages about progress")
        boolean verbose = false;

        Opts() {
        }
    }
}

