/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.watcher;

import java.io.File;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jConfiguration {
    private final boolean usingProperties;
    private final String filename;
    private final File log4jFile;
    private final String auditConfig;

    public Log4jConfiguration(String filename) {
        this.usingProperties = filename != null && filename.endsWith(".properties");
        this.filename = filename;
        this.log4jFile = new File(filename);
        this.auditConfig = String.format("%s/auditLog.xml", System.getenv("ACCUMULO_CONF_DIR"));
    }

    public boolean isUsingProperties() {
        return this.usingProperties;
    }

    public void resetLogger() {
        if (this.log4jFile.exists() && this.log4jFile.isFile() && this.log4jFile.canRead()) {
            LogManager.resetConfiguration();
            if (this.usingProperties) {
                new PropertyConfigurator().doConfigure(this.filename, LogManager.getLoggerRepository());
            } else {
                new DOMConfigurator().doConfigure(this.filename, LogManager.getLoggerRepository());
            }
            DOMConfigurator.configureAndWatch((String)this.auditConfig, (long)5000L);
        }
    }
}

