/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class DistributedWorkQueue {
    private static final String LOCKS_NODE = "locks";
    private static final Logger log = Logger.getLogger(DistributedWorkQueue.class);
    private ThreadPoolExecutor threadPool;
    private ZooReaderWriter zoo = ZooReaderWriter.getInstance();
    private String path;
    private AtomicInteger numTask = new AtomicInteger(0);

    private void lookForWork(final Processor processor, List<String> children) {
        if (children.size() == 0) {
            return;
        }
        if (this.numTask.get() >= this.threadPool.getCorePoolSize()) {
            return;
        }
        Random random = new Random();
        Collections.shuffle(children, random);
        try {
            for (final String child : children) {
                if (child.equals(LOCKS_NODE)) continue;
                final String lockPath = this.path + "/locks/" + child;
                try {
                    this.zoo.putEphemeralData(lockPath, new byte[0]);
                }
                catch (KeeperException.NodeExistsException nee) {
                    continue;
                }
                final String childPath = this.path + "/" + child;
                if (!this.zoo.exists(childPath)) {
                    this.zoo.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
                    continue;
                }
                if (this.numTask.get() >= this.threadPool.getCorePoolSize()) {
                    this.zoo.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
                    break;
                }
                log.debug((Object)("got lock for " + child));
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            try {
                                processor.newProcessor().process(child, DistributedWorkQueue.this.zoo.getData(childPath, null));
                                try {
                                    DistributedWorkQueue.this.zoo.recursiveDelete(childPath, ZooUtil.NodeMissingPolicy.SKIP);
                                }
                                catch (Exception e) {
                                    log.error((Object)("Error received when trying to delete entry in zookeeper " + childPath), (Throwable)e);
                                }
                            }
                            catch (Exception e) {
                                log.warn((Object)("Failed to process work " + child), (Throwable)e);
                            }
                            try {
                                DistributedWorkQueue.this.zoo.recursiveDelete(lockPath, ZooUtil.NodeMissingPolicy.SKIP);
                            }
                            catch (Exception e) {
                                log.error((Object)("Error received when trying to delete entry in zookeeper " + childPath), (Throwable)e);
                            }
                        }
                        finally {
                            DistributedWorkQueue.this.numTask.decrementAndGet();
                        }
                        try {
                            DistributedWorkQueue.this.lookForWork(processor, DistributedWorkQueue.this.zoo.getChildren(DistributedWorkQueue.this.path));
                        }
                        catch (KeeperException e) {
                            log.error((Object)"Failed to look for work", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            log.info((Object)"Interrupted looking for work", (Throwable)e);
                        }
                    }
                };
                this.numTask.incrementAndGet();
                this.threadPool.execute(task);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected error", t);
        }
    }

    public DistributedWorkQueue(String path) {
        this.path = path;
    }

    public void startProcessing(final Processor processor, ThreadPoolExecutor executorService) throws KeeperException, InterruptedException {
        this.threadPool = executorService;
        this.zoo.mkdirs(this.path);
        this.zoo.mkdirs(this.path + "/" + LOCKS_NODE);
        List children = this.zoo.getChildren(this.path, new Watcher(){

            public void process(WatchedEvent event) {
                switch (event.getType()) {
                    case NodeChildrenChanged: {
                        if (event.getPath().equals(DistributedWorkQueue.this.path)) {
                            try {
                                DistributedWorkQueue.this.lookForWork(processor, DistributedWorkQueue.this.zoo.getChildren(DistributedWorkQueue.this.path, this));
                            }
                            catch (KeeperException e) {
                                log.error((Object)"Failed to look for work", (Throwable)e);
                            }
                            catch (InterruptedException e) {
                                log.info((Object)"Interrupted looking for work", (Throwable)e);
                            }
                            break;
                        }
                        log.info((Object)("Unexpected path for NodeChildrenChanged event " + event.getPath()));
                        break;
                    }
                    case NodeCreated: 
                    case NodeDataChanged: 
                    case NodeDeleted: 
                    case None: {
                        log.info((Object)("Got unexpected zookeeper event: " + event.getType() + " for " + DistributedWorkQueue.this.path));
                    }
                }
            }
        });
        this.lookForWork(processor, children);
        Random r = new Random();
        SimpleTimer.getInstance().schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    DistributedWorkQueue.this.lookForWork(processor, DistributedWorkQueue.this.zoo.getChildren(DistributedWorkQueue.this.path));
                }
                catch (KeeperException e) {
                    log.error((Object)"Failed to look for work", (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.info((Object)"Interrupted looking for work", (Throwable)e);
                }
            }
        }, r.nextInt(60000), 60000L);
    }

    public void addWork(String workId, byte[] data) throws KeeperException, InterruptedException {
        if (workId.equalsIgnoreCase(LOCKS_NODE)) {
            throw new IllegalArgumentException("locks is reserved work id");
        }
        this.zoo.mkdirs(this.path);
        this.zoo.putPersistentData(this.path + "/" + workId, data, ZooUtil.NodeExistsPolicy.SKIP);
    }

    public List<String> getWorkQueued() throws KeeperException, InterruptedException {
        ArrayList<String> children = new ArrayList<String>(this.zoo.getChildren(this.path));
        children.remove(LOCKS_NODE);
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone(Set<String> workIDs) throws KeeperException, InterruptedException {
        final Object condVar = new Object();
        Watcher watcher = new Watcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                switch (event.getType()) {
                    case NodeChildrenChanged: {
                        Object object = condVar;
                        synchronized (object) {
                            condVar.notify();
                            break;
                        }
                    }
                    case NodeCreated: 
                    case NodeDataChanged: 
                    case NodeDeleted: 
                    case None: {
                        log.info((Object)("Got unexpected zookeeper event: " + event.getType() + " for " + DistributedWorkQueue.this.path));
                    }
                }
            }
        };
        List children = this.zoo.getChildren(this.path, watcher);
        while (!Collections.disjoint(children, workIDs)) {
            Object object = condVar;
            synchronized (object) {
                condVar.wait(10000L);
            }
            children = this.zoo.getChildren(this.path, watcher);
        }
    }

    public static interface Processor {
        public Processor newProcessor();

        public void process(String var1, byte[] var2);
    }
}

