/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.zookeeper;

import com.google.common.base.Charsets;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.conf.ServerConfiguration;

public class ZooReaderWriterFactory {
    private static final String SCHEME = "digest";
    private static final String USER = "accumulo";
    private static IZooReaderWriter instance = null;

    public IZooReaderWriter getZooReaderWriter(String string, int timeInMillis, String secret) {
        return new ZooReaderWriter(string, timeInMillis, SCHEME, ("accumulo:" + secret).getBytes(Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IZooReaderWriter getInstance() {
        Class<ZooReaderWriterFactory> clazz = ZooReaderWriterFactory.class;
        synchronized (ZooReaderWriterFactory.class) {
            if (instance == null) {
                SiteConfiguration conf = ServerConfiguration.getSiteConfiguration();
                instance = this.getZooReaderWriter(conf.get(Property.INSTANCE_ZK_HOST), (int)conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT), conf.get(Property.INSTANCE_SECRET));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }
}

