/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.conf.ZooConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.hadoop.fs.Path;

class ZooConfigurationFactory {
    private static final Map<String, ZooConfiguration> instances = new HashMap<String, ZooConfiguration>();

    ZooConfigurationFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZooConfiguration getInstance(Instance inst, ZooCacheFactory zcf, AccumuloConfiguration parent) {
        ZooConfiguration config;
        String instanceId;
        if (inst == null) {
            VolumeManager fs;
            try {
                fs = VolumeManagerImpl.get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path instanceIdPath = Accumulo.getAccumuloInstanceIdPath(fs);
            instanceId = ZooUtil.getInstanceIDFromHdfs((Path)instanceIdPath, (AccumuloConfiguration)parent);
        } else {
            instanceId = inst.getInstanceID();
        }
        Map<String, ZooConfiguration> map = instances;
        synchronized (map) {
            config = instances.get(instanceId);
            if (config == null) {
                ZooCache propCache = inst == null ? zcf.getZooCache(parent.get(Property.INSTANCE_ZK_HOST), (int)parent.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT)) : zcf.getZooCache(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut());
                config = new ZooConfiguration(instanceId, propCache, parent);
                instances.put(instanceId, config);
            }
        }
        return config;
    }

    public ZooConfiguration getInstance(Instance inst, AccumuloConfiguration parent) {
        return this.getInstance(inst, new ZooCacheFactory(), parent);
    }
}

