/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListInstances {
    private static final Logger log = LoggerFactory.getLogger(ListInstances.class);
    private static final int NAME_WIDTH = 20;
    private static final int UUID_WIDTH = 37;
    private static final int MASTER_WIDTH = 30;
    private static final int ZOOKEEPER_TIMER_MILLIS = 30000;
    static Opts opts = new Opts();
    static int errors = 0;

    public static void main(String[] args) {
        opts.parseArgs(ListInstances.class.getName(), args, new Object[0]);
        if (ListInstances.opts.keepers == null) {
            ListInstances.opts.keepers = SiteConfiguration.getInstance().get(Property.INSTANCE_ZK_HOST);
        }
        String keepers = ListInstances.opts.keepers;
        boolean printAll = ListInstances.opts.printAll;
        boolean printErrors = ListInstances.opts.printErrors;
        ListInstances.listInstances(keepers, printAll, printErrors);
    }

    static synchronized void listInstances(String keepers, boolean printAll, boolean printErrors) {
        errors = 0;
        System.out.println("INFO : Using ZooKeepers " + keepers);
        ZooReader rdr = new ZooReader(keepers, 30000);
        ZooCache cache = new ZooCache(keepers, 30000);
        TreeMap<String, UUID> instanceNames = ListInstances.getInstanceNames(rdr, printErrors);
        System.out.println();
        ListInstances.printHeader();
        for (Map.Entry<String, UUID> entry : instanceNames.entrySet()) {
            ListInstances.printInstanceInfo(cache, entry.getKey(), entry.getValue(), printErrors);
        }
        TreeSet<UUID> instancedIds = ListInstances.getInstanceIDs(rdr, printErrors);
        instancedIds.removeAll(instanceNames.values());
        if (printAll) {
            for (UUID uuid : instancedIds) {
                ListInstances.printInstanceInfo(cache, null, uuid, printErrors);
            }
        } else if (instancedIds.size() > 0) {
            System.out.println();
            System.out.println("INFO : " + instancedIds.size() + " unamed instances were not printed, run with --print-all to see all instances");
        } else {
            System.out.println();
        }
        if (!printErrors && errors > 0) {
            System.err.println("WARN : There were " + errors + " errors, run with --print-errors to see more info");
        }
    }

    private static void printHeader() {
        System.out.printf(" %-20s| %-37s| %-30s%n", "Instance Name", "Instance ID", "Master");
        System.out.printf("%21s+%38s+%31s%n", new CharFiller('-'), new CharFiller('-'), new CharFiller('-'));
    }

    private static void printInstanceInfo(ZooCache cache, String instanceName, UUID iid, boolean printErrors) {
        String master = ListInstances.getMaster(cache, iid, printErrors);
        if (instanceName == null) {
            instanceName = "";
        }
        if (master == null) {
            master = "";
        }
        System.out.printf("%20s |%37s |%30s%n", "\"" + instanceName + "\"", iid, master);
    }

    private static String getMaster(ZooCache cache, UUID iid, boolean printErrors) {
        if (iid == null) {
            return null;
        }
        try {
            String masterLocPath = "/accumulo/" + iid + "/masters/lock";
            byte[] master = ZooLock.getLockData((ZooCache)cache, (String)masterLocPath, null);
            if (master == null) {
                return null;
            }
            return new String(master, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            ListInstances.handleException(e, printErrors);
            return null;
        }
    }

    private static TreeMap<String, UUID> getInstanceNames(ZooReader zk, boolean printErrors) {
        List names;
        String instancesPath = "/accumulo/instances";
        TreeMap<String, UUID> tm = new TreeMap<String, UUID>();
        try {
            names = zk.getChildren(instancesPath);
        }
        catch (Exception e) {
            ListInstances.handleException(e, printErrors);
            return tm;
        }
        for (String name : names) {
            String instanceNamePath = "/accumulo/instances/" + name;
            try {
                UUID iid = UUID.fromString(new String(zk.getData(instanceNamePath, null), StandardCharsets.UTF_8));
                tm.put(name, iid);
            }
            catch (Exception e) {
                ListInstances.handleException(e, printErrors);
                tm.put(name, null);
            }
        }
        return tm;
    }

    private static TreeSet<UUID> getInstanceIDs(ZooReader zk, boolean printErrors) {
        TreeSet<UUID> ts = new TreeSet<UUID>();
        try {
            List children = zk.getChildren("/accumulo");
            for (String iid : children) {
                if (iid.equals("instances")) continue;
                try {
                    ts.add(UUID.fromString(iid));
                }
                catch (Exception e) {
                    log.error("Exception: " + e);
                }
            }
        }
        catch (Exception e) {
            ListInstances.handleException(e, printErrors);
        }
        return ts;
    }

    private static void handleException(Exception e, boolean printErrors) {
        if (printErrors) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        ++errors;
    }

    private static class CharFiller
    implements Formattable {
        char c;

        CharFiller(char c) {
            this.c = c;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < width; ++i) {
                sb.append(this.c);
            }
            formatter.format(sb.toString(), new Object[0]);
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--print-errors"}, description="display errors while listing instances")
        boolean printErrors = false;
        @Parameter(names={"--print-all"}, description="print information for all instances, not just those with names")
        boolean printAll = false;
        @Parameter(names={"-z", "--zookeepers"}, description="the zookeepers to contact")
        String keepers = null;

        Opts() {
        }
    }
}

