/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemPropUtil.class);

    public static boolean setSystemProperty(String property, String value) throws KeeperException, InterruptedException {
        Property p = Property.getPropertyByKey((String)property);
        if (p != null && !p.getType().isValidFormat(value) || !Property.isValidZooPropertyKey((String)property)) {
            log.warn("Ignoring property {} it is null, an invalid format, or not capable of being changed in zookeeper", (Object)property);
            return false;
        }
        String zPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/config" + "/" + property;
        ZooReaderWriter.getInstance().putPersistentData(zPath, value.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        return true;
    }

    public static void removeSystemProperty(String property) throws InterruptedException, KeeperException {
        String zPath = ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/config" + "/" + property;
        ZooReaderWriter.getInstance().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.FAIL);
    }
}

