/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.InitialMultiScan;
import org.apache.accumulo.core.data.thrift.MultiScanResult;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.metadata.MetadataServicer;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyTabletAssignments {
    private static final Logger log = LoggerFactory.getLogger(VerifyTabletAssignments.class);

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(VerifyTabletAssignments.class.getName(), args, new Object[0]);
        ClientContext context = new ClientContext(opts.getInstance(), new Credentials(opts.getPrincipal(), opts.getToken()), opts.getClientConfiguration());
        Connector conn = opts.getConnector();
        for (String table : conn.tableOperations().list()) {
            VerifyTabletAssignments.checkTable(context, opts, table, null);
        }
    }

    private static void checkTable(final ClientContext context, Opts opts, String tableName, HashSet<KeyExtent> check) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, InterruptedException {
        if (check == null) {
            System.out.println("Checking table " + tableName);
        } else {
            System.out.println("Checking table " + tableName + " again, failures " + check.size());
        }
        TreeMap tabletLocations = new TreeMap();
        String tableId = (String)Tables.getNameToIdMap((Instance)context.getInstance()).get(tableName);
        MetadataServicer.forTableId((ClientContext)context, (String)tableId).getTabletLocations(tabletLocations);
        final HashSet<KeyExtent> failures = new HashSet<KeyExtent>();
        TreeMap<HostAndPort, ArrayList<KeyExtent>> extentsPerServer = new TreeMap<HostAndPort, ArrayList<KeyExtent>>();
        for (Map.Entry entry : tabletLocations.entrySet()) {
            KeyExtent keyExtent = (KeyExtent)entry.getKey();
            String loc = (String)entry.getValue();
            if (loc == null) {
                System.out.println(" Tablet " + keyExtent + " has no location");
            } else if (opts.verbose) {
                System.out.println(" Tablet " + keyExtent + " is located at " + loc);
            }
            if (loc == null) continue;
            HostAndPort parsedLoc = HostAndPort.fromString((String)loc);
            ArrayList<KeyExtent> extentList = (ArrayList<KeyExtent>)extentsPerServer.get(parsedLoc);
            if (extentList == null) {
                extentList = new ArrayList<KeyExtent>();
                extentsPerServer.put(parsedLoc, extentList);
            }
            if (check != null && !check.contains(keyExtent)) continue;
            extentList.add(keyExtent);
        }
        ExecutorService tp = Executors.newFixedThreadPool(20);
        for (final Map.Entry entry : extentsPerServer.entrySet()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        VerifyTabletAssignments.checkTabletServer(context, entry, failures);
                    }
                    catch (Exception e) {
                        log.error("Failure on tablet server '" + entry.getKey() + ".", (Throwable)e);
                        failures.addAll((Collection)entry.getValue());
                    }
                }
            };
            tp.execute(r);
        }
        tp.shutdown();
        while (!tp.awaitTermination(1L, TimeUnit.HOURS)) {
        }
        if (failures.size() > 0) {
            VerifyTabletAssignments.checkTable(context, opts, tableName, failures);
        }
    }

    private static void checkFailures(HostAndPort server, HashSet<KeyExtent> failures, MultiScanResult scanResult) {
        for (TKeyExtent tke : scanResult.failures.keySet()) {
            KeyExtent ke = new KeyExtent(tke);
            System.out.println(" Tablet " + ke + " failed at " + server);
            failures.add(ke);
        }
    }

    private static void checkTabletServer(ClientContext context, Map.Entry<HostAndPort, List<KeyExtent>> entry, HashSet<KeyExtent> failures) throws ThriftSecurityException, TException, NoSuchScanIDException {
        TabletClientService.Client client = ThriftUtil.getTServerClient((HostAndPort)entry.getKey(), (ClientContext)context);
        TreeMap<TKeyExtent, List<TRange>> batch = new TreeMap<TKeyExtent, List<TRange>>();
        for (KeyExtent keyExtent : entry.getValue()) {
            Text row = keyExtent.getEndRow();
            Text row2 = null;
            if (row == null) {
                row = keyExtent.getPrevEndRow();
                if (row != null) {
                    row = new Text(row);
                    row.append(new byte[]{97}, 0, 1);
                } else {
                    row = new Text("1234567890");
                }
                row2 = new Text(row);
                row2.append(new byte[]{33}, 0, 1);
            } else {
                row = new Text(row);
                row2 = new Text(row);
                row.getBytes()[row.getLength() - 1] = (byte)(row.getBytes()[row.getLength() - 1] - 1);
            }
            Range r = new Range(row, true, row2, false);
            batch.put(keyExtent.toThrift(), Collections.singletonList(r.toThrift()));
        }
        TInfo tinfo = Tracer.traceInfo();
        Map emptyMapSMapSS = Collections.emptyMap();
        List emptyListIterInfo = Collections.emptyList();
        List emptyListColumn = Collections.emptyList();
        InitialMultiScan is = client.startMultiScan(tinfo, context.rpcCreds(), batch, emptyListColumn, emptyListIterInfo, emptyMapSMapSS, Authorizations.EMPTY.getAuthorizationsBB(), false);
        if (is.result.more) {
            MultiScanResult result = client.continueMultiScan(tinfo, is.scanID);
            VerifyTabletAssignments.checkFailures(entry.getKey(), failures, result);
            while (result.more) {
                result = client.continueMultiScan(tinfo, is.scanID);
                VerifyTabletAssignments.checkFailures(entry.getKey(), failures, result);
            }
        }
        client.closeMultiScan(tinfo, is.scanID);
        ThriftUtil.returnClient((TServiceClient)((TServiceClient)client));
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"-v", "--verbose"}, description="verbose mode (prints locations of tablets)")
        boolean verbose = false;

        Opts() {
        }
    }
}

