/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.TableParentConfiguration;
import org.apache.accumulo.server.conf.ZooConfigurationFactory;

public class ServerConfigurationFactory
extends ServerConfiguration {
    private static final Map<String, Map<String, TableConfiguration>> tableConfigs = new HashMap<String, Map<String, TableConfiguration>>(1);
    private static final Map<String, Map<String, NamespaceConfiguration>> namespaceConfigs = new HashMap<String, Map<String, NamespaceConfiguration>>(1);
    private static final Map<String, Map<String, NamespaceConfiguration>> tableParentConfigs = new HashMap<String, Map<String, NamespaceConfiguration>>(1);
    private static final SecurityPermission CONFIGURATION_PERMISSION = new SecurityPermission("configurationPermission");
    private static final SecurityManager SM = System.getSecurityManager();
    private final Instance instance;
    private final String instanceID;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private SiteConfiguration siteConfig = null;
    private DefaultConfiguration defaultConfig = null;
    private AccumuloConfiguration systemConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInstanceToCaches(String iid) {
        Map<String, Map<String, ObservableConfiguration>> map = tableConfigs;
        synchronized (map) {
            if (!tableConfigs.containsKey(iid)) {
                tableConfigs.put(iid, new HashMap());
            }
        }
        map = namespaceConfigs;
        synchronized (map) {
            if (!namespaceConfigs.containsKey(iid)) {
                namespaceConfigs.put(iid, new HashMap());
            }
        }
        map = tableParentConfigs;
        synchronized (map) {
            if (!tableParentConfigs.containsKey(iid)) {
                tableParentConfigs.put(iid, new HashMap());
            }
        }
    }

    private static void checkPermissions() {
        if (SM != null) {
            SM.checkPermission(CONFIGURATION_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeCachedTableConfiguration(String instanceId, String tableId) {
        Map<String, Map<String, TableConfiguration>> map = tableConfigs;
        synchronized (map) {
            return tableConfigs.get(instanceId).remove(tableId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeCachedNamespaceConfiguration(String instanceId, String namespaceId) {
        Map<String, Map<String, NamespaceConfiguration>> map = namespaceConfigs;
        synchronized (map) {
            return namespaceConfigs.get(instanceId).remove(namespaceId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCachedConfigurations() {
        Map<String, Map<String, ObservableConfiguration>> map = tableConfigs;
        synchronized (map) {
            tableConfigs.clear();
        }
        map = namespaceConfigs;
        synchronized (map) {
            namespaceConfigs.clear();
        }
        map = tableParentConfigs;
        synchronized (map) {
            tableParentConfigs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expireAllTableObservers() {
        Map<String, Map<String, TableConfiguration>> map = tableConfigs;
        synchronized (map) {
            for (Map<String, TableConfiguration> instanceMap : tableConfigs.values()) {
                for (TableConfiguration c : instanceMap.values()) {
                    c.expireAllObservers();
                }
            }
        }
    }

    public ServerConfigurationFactory(Instance instance) {
        this.instance = instance;
        this.instanceID = instance.getInstanceID();
        ServerConfigurationFactory.addInstanceToCaches(this.instanceID);
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    public synchronized SiteConfiguration getSiteConfiguration() {
        if (this.siteConfig == null) {
            ServerConfigurationFactory.checkPermissions();
            this.siteConfig = SiteConfiguration.getInstance();
        }
        return this.siteConfig;
    }

    public synchronized DefaultConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            ServerConfigurationFactory.checkPermissions();
            this.defaultConfig = DefaultConfiguration.getInstance();
        }
        return this.defaultConfig;
    }

    @Override
    public synchronized AccumuloConfiguration getConfiguration() {
        if (this.systemConfig == null) {
            ServerConfigurationFactory.checkPermissions();
            this.systemConfig = new ZooConfigurationFactory().getInstance(this.instance, this.zcf, (AccumuloConfiguration)this.getSiteConfiguration());
        }
        return this.systemConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableConfiguration getTableConfiguration(String tableId) {
        TableConfiguration conf;
        ServerConfigurationFactory.checkPermissions();
        Map<String, Map<String, TableConfiguration>> map = tableConfigs;
        synchronized (map) {
            conf = tableConfigs.get(this.instanceID).get(tableId);
        }
        if (conf == null && Tables.exists((Instance)this.instance, (String)tableId)) {
            conf = new TableConfiguration(this.instance, tableId, this.getNamespaceConfigurationForTable(tableId));
            ConfigSanityCheck.validate((Iterable)((Object)conf));
            map = tableConfigs;
            synchronized (map) {
                Map<String, TableConfiguration> configs = tableConfigs.get(this.instanceID);
                TableConfiguration existingConf = configs.get(tableId);
                if (null == existingConf) {
                    configs.put(tableId, conf);
                } else {
                    conf = existingConf;
                }
            }
        }
        return conf;
    }

    @Override
    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return this.getTableConfiguration(extent.getTableId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceConfiguration getNamespaceConfigurationForTable(String tableId) {
        NamespaceConfiguration conf;
        ServerConfigurationFactory.checkPermissions();
        Map<String, Map<String, NamespaceConfiguration>> map = tableParentConfigs;
        synchronized (map) {
            conf = tableParentConfigs.get(this.instanceID).get(tableId);
        }
        if (conf == null) {
            conf = new TableParentConfiguration(tableId, this.instance, this.getConfiguration());
            ConfigSanityCheck.validate((Iterable)((Object)conf));
            map = tableParentConfigs;
            synchronized (map) {
                tableParentConfigs.get(this.instanceID).put(tableId, conf);
            }
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceConfiguration getNamespaceConfiguration(String namespaceId) {
        NamespaceConfiguration conf;
        ServerConfigurationFactory.checkPermissions();
        Map<String, Map<String, NamespaceConfiguration>> map = namespaceConfigs;
        synchronized (map) {
            conf = namespaceConfigs.get(this.instanceID).get(namespaceId);
        }
        if (conf == null) {
            conf = new NamespaceConfiguration(namespaceId, this.instance, this.getConfiguration());
            conf.setZooCacheFactory(this.zcf);
            ConfigSanityCheck.validate((Iterable)((Object)conf));
            map = namespaceConfigs;
            synchronized (map) {
                namespaceConfigs.get(this.instanceID).put(namespaceId, conf);
            }
        }
        return conf;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }
}

