/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.hadoop.io.Text;

public class TServerInstance
implements Comparable<TServerInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient HostAndPort location;
    private String session;
    private String cachedStringRepresentation;

    public TServerInstance(HostAndPort address, String session) {
        this.location = address;
        this.session = session;
        this.cachedStringRepresentation = this.hostPort() + "[" + session + "]";
    }

    public TServerInstance(HostAndPort address, long session) {
        this(address, Long.toHexString(session));
    }

    public TServerInstance(String address, long session) {
        this(AddressUtil.parseAddress((String)address, (boolean)false), Long.toHexString(session));
    }

    public TServerInstance(Value address, Text session) {
        this(AddressUtil.parseAddress((String)new String(address.get(), StandardCharsets.UTF_8), (boolean)false), session.toString());
    }

    public void putLocation(Mutation m) {
        m.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, this.asColumnQualifier(), this.asMutationValue());
    }

    public void putFutureLocation(Mutation m) {
        m.put(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME, this.asColumnQualifier(), this.asMutationValue());
    }

    public void putLastLocation(Mutation m) {
        m.put(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME, this.asColumnQualifier(), this.asMutationValue());
    }

    public void clearLastLocation(Mutation m) {
        m.putDelete(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME, this.asColumnQualifier());
    }

    public void clearFutureLocation(Mutation m) {
        m.putDelete(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME, this.asColumnQualifier());
    }

    public void clearLocation(Mutation m) {
        m.putDelete(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, this.asColumnQualifier());
    }

    @Override
    public int compareTo(TServerInstance other) {
        if (this == other) {
            return 0;
        }
        return this.toString().compareTo(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TServerInstance) {
            return this.compareTo((TServerInstance)obj) == 0;
        }
        return false;
    }

    public String toString() {
        return this.cachedStringRepresentation;
    }

    public String host() {
        return this.getLocation().getHost();
    }

    public String hostPort() {
        return this.getLocation().toString();
    }

    private Text asColumnQualifier() {
        return new Text(this.getSession());
    }

    private Value asMutationValue() {
        return new Value(this.getLocation().toString().getBytes(StandardCharsets.UTF_8));
    }

    public HostAndPort getLocation() {
        return this.location;
    }

    public String getSession() {
        return this.session;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.location.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.location = HostAndPort.fromString((String)in.readObject().toString());
    }
}

