/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.metrics;

import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.ThriftMetricsKeys;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;

public class Metrics2ThriftMetrics
implements Metrics,
MetricsSource,
ThriftMetricsKeys {
    public static final String CONTEXT = "thrift";
    private final MetricsSystem system;
    private final MetricsRegistry registry;
    private final String record;
    private final String name;
    private final String desc;

    Metrics2ThriftMetrics(MetricsSystem system, String serverName, String threadName) {
        this.system = system;
        this.record = serverName;
        this.name = "Thrift,sub=" + serverName;
        this.desc = "Thrift Server Metrics - " + serverName + " " + threadName;
        this.registry = new MetricsRegistry(Interns.info((String)this.name, (String)this.desc));
    }

    @Override
    public void add(String name, long time) {
        this.registry.add(name, time);
    }

    @Override
    public void register() {
        this.system.register(this.name, this.desc, (Object)this);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(this.record).setContext(CONTEXT);
        this.registry.snapshot(builder, all);
    }
}

