/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.replication.ReplicaSystemFactory;
import org.apache.accumulo.server.replication.StatusFormatter;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationUtil {
    private static final Logger log = LoggerFactory.getLogger(ReplicationUtil.class);
    public static final String STATUS_FORMATTER_CLASS_NAME = StatusFormatter.class.getName();
    private final AccumuloServerContext context;
    private final ZooCache zooCache;
    private final ReplicaSystemFactory factory;

    public ReplicationUtil(AccumuloServerContext context) {
        this(context, new ZooCache(), new ReplicaSystemFactory());
    }

    public ReplicationUtil(AccumuloServerContext context, ZooCache cache, ReplicaSystemFactory factory) {
        this.zooCache = cache;
        this.context = context;
        this.factory = factory;
    }

    public int getMaxReplicationThreads(MasterMonitorInfo mmi) {
        int activeTservers = mmi.getTServerInfoSize();
        int replicationThreadsPerServer = Integer.parseInt(this.context.getConfiguration().get(Property.REPLICATION_WORKER_THREADS));
        return activeTservers * replicationThreadsPerServer;
    }

    public Map<String, String> getPeers() {
        HashMap<String, String> peers = new HashMap<String, String>();
        for (Map.Entry property : this.context.getConfiguration().getAllPropertiesWithPrefix(Property.REPLICATION_PEERS).entrySet()) {
            Map.Entry<String, String> entry;
            String key = (String)property.getKey();
            if (key.startsWith(Property.REPLICATION_PEER_USER.getKey()) || key.startsWith(Property.REPLICATION_PEER_PASSWORD.getKey()) || key.startsWith(Property.REPLICATION_PEER_KEYTAB.getKey())) continue;
            String peerName = ((String)property.getKey()).substring(Property.REPLICATION_PEERS.getKey().length());
            try {
                entry = this.factory.parseReplicaSystemConfiguration((String)property.getValue());
            }
            catch (Exception e) {
                log.warn("Could not instantiate ReplicaSystem for {} with configuration {}", new Object[]{property.getKey(), property.getValue(), e});
                continue;
            }
            peers.put(peerName, entry.getKey());
        }
        return peers;
    }

    public Set<ReplicationTarget> getReplicationTargets() {
        HashSet<ReplicationTarget> allConfiguredTargets = new HashSet<ReplicationTarget>();
        SortedMap tableNameToId = Tables.getNameToIdMap((Instance)this.context.getInstance());
        for (String table : tableNameToId.keySet()) {
            if ("accumulo.metadata".equals(table) || "accumulo.root".equals(table)) continue;
            String localId = (String)tableNameToId.get(table);
            if (null == localId) {
                log.trace("Could not determine ID for {}", (Object)table);
                continue;
            }
            TableConfiguration tableConf = this.context.getServerConfigurationFactory().getTableConfiguration(localId);
            if (null == tableConf) {
                log.trace("Could not get configuration for table {} (it no longer exists)", (Object)table);
                continue;
            }
            for (Map.Entry prop : tableConf.getAllPropertiesWithPrefix(Property.TABLE_REPLICATION_TARGET).entrySet()) {
                String peerName = ((String)prop.getKey()).substring(Property.TABLE_REPLICATION_TARGET.getKey().length());
                String remoteIdentifier = (String)prop.getValue();
                ReplicationTarget target = new ReplicationTarget(peerName, remoteIdentifier, localId);
                allConfiguredTargets.add(target);
            }
        }
        return allConfiguredTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ReplicationTarget, Long> getPendingReplications() {
        BatchScanner bs;
        HashMap<ReplicationTarget, Long> counts = new HashMap<ReplicationTarget, Long>();
        try {
            bs = this.context.getConnector().createBatchScanner("accumulo.replication", Authorizations.EMPTY, 4);
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            log.debug("No replication table exists", e);
            return counts;
        }
        bs.setRanges(Collections.singleton(new Range()));
        ReplicationSchema.WorkSection.limit((ScannerBase)bs);
        try {
            Text buffer = new Text();
            for (Map.Entry entry : bs) {
                Key k = (Key)entry.getKey();
                k.getColumnQualifier(buffer);
                ReplicationTarget target = ReplicationTarget.from((Text)buffer);
                Long count = (Long)counts.get(target);
                if (null == count) {
                    counts.put(target, 1L);
                    continue;
                }
                counts.put(target, count + 1L);
            }
        }
        finally {
            bs.close();
        }
        return counts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Path> getPendingReplicationPaths() {
        BatchScanner bs;
        HashSet<Path> paths = new HashSet<Path>();
        try {
            bs = this.context.getConnector().createBatchScanner("accumulo.replication", Authorizations.EMPTY, 4);
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            log.debug("No replication table exists", e);
            return paths;
        }
        bs.setRanges(Collections.singleton(new Range()));
        ReplicationSchema.StatusSection.limit((ScannerBase)bs);
        try {
            Text buffer = new Text();
            for (Map.Entry entry : bs) {
                Key k = (Key)entry.getKey();
                k.getRow(buffer);
                paths.add(new Path(buffer.toString()));
            }
        }
        finally {
            bs.close();
        }
        return paths;
    }

    public String getAbsolutePath(Connector conn, String workQueuePath, String queueKey) {
        byte[] data = this.zooCache.get(workQueuePath + "/" + queueKey);
        if (null != data) {
            return new String(data, StandardCharsets.UTF_8);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProgress(Connector conn, String path, ReplicationTarget target) {
        String status = "Unknown";
        if (null != path) {
            Scanner s;
            try {
                s = ReplicationTable.getScanner((Connector)conn);
            }
            catch (ReplicationTableOfflineException e) {
                log.debug("Replication table no longer online", (Throwable)e);
                return status;
            }
            s.setRange(Range.exact((CharSequence)path));
            s.fetchColumn(ReplicationSchema.WorkSection.NAME, target.toText());
            Map.Entry kv = null;
            try {
                kv = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
            }
            catch (NoSuchElementException e) {
                log.trace("Could not find status of {} replicating to {}", (Object)path, (Object)target);
                status = "Unknown";
            }
            finally {
                s.close();
            }
            if (null != kv) {
                try {
                    Replication.Status stat = Replication.Status.parseFrom(((Value)kv.getValue()).get());
                    status = StatusUtil.isFullyReplicated(stat) ? "Finished" : (stat.getInfiniteEnd() ? stat.getBegin() + "/&infin; records" : stat.getBegin() + "/" + stat.getEnd() + " records");
                }
                catch (InvalidProtocolBufferException e) {
                    log.warn("Could not deserialize protobuf for {}", kv.getKey(), (Object)e);
                    status = "Unknown";
                }
            }
        }
        return status;
    }

    public Map<String, String> invert(Map<String, String> map) {
        HashMap<String, String> newMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }
}

