/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.replication;

import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusFormatter
implements Formatter {
    private static final Logger log = LoggerFactory.getLogger(StatusFormatter.class);
    private static final Set<Text> REPLICATION_COLFAMS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Text[]{MetadataSchema.ReplicationSection.COLF, ReplicationSchema.StatusSection.NAME, ReplicationSchema.WorkSection.NAME, ReplicationSchema.OrderSection.NAME}));
    private Iterator<Map.Entry<Key, Value>> iterator;
    private boolean printTimestamps;
    private static ThreadLocal<Date> tmpDate = new ThreadLocal<Date>(){

        @Override
        protected Date initialValue() {
            return new Date();
        }
    };
    private static final ThreadLocal<DateFormat> formatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new DefaultFormatter.DefaultDateFormat();
        }
    };

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public String next() {
        DateFormat timestampFormat;
        Map.Entry<Key, Value> entry = this.iterator.next();
        DateFormat dateFormat = timestampFormat = this.printTimestamps ? formatter.get() : null;
        if (REPLICATION_COLFAMS.contains(entry.getKey().getColumnFamily())) {
            Replication.Status status;
            try {
                status = Replication.Status.parseFrom(entry.getValue().get());
            }
            catch (InvalidProtocolBufferException e) {
                log.trace("Could not deserialize protocol buffer for {}", (Object)entry.getKey(), (Object)e);
                status = null;
            }
            return this.formatEntry(entry.getKey(), status, timestampFormat);
        }
        return DefaultFormatter.formatEntry(entry, (DateFormat)timestampFormat);
    }

    public String formatEntry(Key key, Replication.Status status, DateFormat timestampFormat) {
        StringBuilder sb = new StringBuilder();
        Text buffer = new Text();
        key.getRow(buffer);
        this.appendText(sb, buffer).append(" ");
        key.getColumnFamily(buffer);
        this.appendText(sb, buffer).append(":");
        key.getColumnQualifier(buffer);
        this.appendText(sb, buffer).append(" ");
        key.getColumnVisibility(buffer);
        sb.append(new ColumnVisibility(buffer));
        if (timestampFormat != null) {
            tmpDate.get().setTime(key.getTimestamp());
            sb.append(" ").append(timestampFormat.format(tmpDate.get()));
        }
        sb.append("\t");
        if (status != null) {
            sb.append(ProtobufUtil.toString((GeneratedMessage)status));
        } else {
            sb.append("Could not deserialize Status protocol buffer");
        }
        return sb.toString();
    }

    protected StringBuilder appendText(StringBuilder sb, Text t) {
        return this.appendBytes(sb, t.getBytes(), 0, t.getLength());
    }

    protected StringBuilder appendBytes(StringBuilder sb, byte[] ba, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            int c = 0xFF & ba[offset + i];
            if (c == 92) {
                sb.append("\\\\");
                continue;
            }
            if (c >= 32 && c <= 126) {
                sb.append((char)c);
                continue;
            }
            sb.append("\\x").append(String.format("%02X", c));
        }
        return sb;
    }

    public void remove() {
        this.iterator.remove();
    }

    public void initialize(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps) {
        this.iterator = scanner.iterator();
        this.printTimestamps = printTimestamps;
    }
}

