/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomNonBlockingServer
extends THsHaServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomNonBlockingServer.class);
    private SelectAcceptThread selectAcceptThread_;
    private volatile boolean stopped_ = false;

    public CustomNonBlockingServer(THsHaServer.Args args) {
        super(args);
    }

    protected Runnable getRunnable(final AbstractNonblockingServer.FrameBuffer frameBuffer) {
        return new Runnable(){

            @Override
            public void run() {
                TNonblockingTransport trans;
                if (frameBuffer instanceof CustomNonblockingFrameBuffer && (trans = ((CustomNonblockingFrameBuffer)frameBuffer).getTransport()) instanceof TNonblockingSocket) {
                    TNonblockingSocket tsock = (TNonblockingSocket)trans;
                    Socket sock = tsock.getSocketChannel().socket();
                    TServerUtils.clientAddress.set(sock.getInetAddress().getHostAddress() + ":" + sock.getPort());
                }
                frameBuffer.invoke();
            }
        };
    }

    protected boolean startThreads() {
        try {
            this.selectAcceptThread_ = new SelectAcceptThread((TNonblockingServerTransport)this.serverTransport_);
            this.selectAcceptThread_.start();
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to start selector thread!", (Throwable)e);
            return false;
        }
    }

    public void stop() {
        this.stopped_ = true;
        if (this.selectAcceptThread_ != null) {
            this.selectAcceptThread_.wakeupSelector();
        }
    }

    public boolean isStopped() {
        return this.selectAcceptThread_.isStopped();
    }

    protected void joinSelector() {
        try {
            this.selectAcceptThread_.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class SelectAcceptThread
    extends AbstractNonblockingServer.AbstractSelectThread {
        private final TNonblockingServerTransport serverTransport;

        public SelectAcceptThread(TNonblockingServerTransport serverTransport) throws IOException {
            super((AbstractNonblockingServer)CustomNonBlockingServer.this);
            this.serverTransport = serverTransport;
            serverTransport.registerSelector(this.selector);
        }

        public boolean isStopped() {
            return CustomNonBlockingServer.this.stopped_;
        }

        public void run() {
            try {
                if (CustomNonBlockingServer.this.eventHandler_ != null) {
                    CustomNonBlockingServer.this.eventHandler_.preServe();
                }
                while (!CustomNonBlockingServer.this.stopped_) {
                    this.select();
                    this.processInterestChanges();
                }
                for (SelectionKey selectionKey : this.selector.keys()) {
                    this.cleanupSelectionKey(selectionKey);
                }
            }
            catch (Throwable t) {
                LOGGER.error("run() exiting due to uncaught error", t);
            }
            finally {
                CustomNonBlockingServer.this.stopped_ = true;
            }
        }

        private void select() {
            try {
                this.selector.select();
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (!CustomNonBlockingServer.this.stopped_ && selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) {
                        this.cleanupSelectionKey(key);
                        continue;
                    }
                    if (key.isAcceptable()) {
                        this.handleAccept();
                        continue;
                    }
                    if (key.isReadable()) {
                        this.handleRead(key);
                        continue;
                    }
                    if (key.isWritable()) {
                        this.handleWrite(key);
                        continue;
                    }
                    LOGGER.warn("Unexpected state in select! " + key.interestOps());
                }
            }
            catch (IOException e) {
                LOGGER.warn("Got an IOException while selecting!", (Throwable)e);
            }
        }

        private void handleAccept() throws IOException {
            block3: {
                SelectionKey clientKey = null;
                TNonblockingTransport client = null;
                try {
                    client = (TNonblockingTransport)this.serverTransport.accept();
                    clientKey = client.registerSelector(this.selector, 1);
                    CustomNonblockingFrameBuffer frameBuffer = CustomNonBlockingServer.this.processorFactory_.isAsyncProcessor() ? new CustomAsyncFrameBuffer(client, clientKey, this) : new CustomFrameBuffer(client, clientKey, this);
                    clientKey.attach(frameBuffer);
                }
                catch (TTransportException tte) {
                    LOGGER.warn("Exception trying to accept!", (Throwable)tte);
                    tte.printStackTrace();
                    if (clientKey != null) {
                        this.cleanupSelectionKey(clientKey);
                    }
                    if (client == null) break block3;
                    client.close();
                }
            }
        }
    }

    private class CustomFrameBuffer
    extends AbstractNonblockingServer.FrameBuffer
    implements CustomNonblockingFrameBuffer {
        private TNonblockingTransport trans;

        public CustomFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer.AbstractSelectThread selectThread) {
            super((AbstractNonblockingServer)CustomNonBlockingServer.this, trans, selectionKey, selectThread);
            this.trans = trans;
        }

        @Override
        public TNonblockingTransport getTransport() {
            return this.trans;
        }
    }

    private class CustomAsyncFrameBuffer
    extends AbstractNonblockingServer.AsyncFrameBuffer
    implements CustomNonblockingFrameBuffer {
        private TNonblockingTransport trans;

        public CustomAsyncFrameBuffer(TNonblockingTransport trans, SelectionKey selectionKey, AbstractNonblockingServer.AbstractSelectThread selectThread) {
            super((AbstractNonblockingServer)CustomNonBlockingServer.this, trans, selectionKey, selectThread);
            this.trans = trans;
        }

        @Override
        public TNonblockingTransport getTransport() {
            return this.trans;
        }
    }

    private static interface CustomNonblockingFrameBuffer {
        public TNonblockingTransport getTransport();
    }
}

